/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.security.AccessController;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.Xid;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.annotation.ClientTransactionPolicy;
import org.wildfly.common.Assert;
import org.wildfly.transaction.client.RemoteTransactionContext;

public final class TransactionInterceptor
implements EJBClientInterceptor {
    private static final RemoteTransactionContext TRANSACTION_SYSTEM = AccessController.doPrivileged(RemoteTransactionContext::getInstance);
    private final Supplier<TransactionManager> transactionManagerSupplier;
    private final Function<Transaction, Xid> xidMapper;

    public TransactionInterceptor(Supplier<TransactionManager> transactionManagerSupplier, Function<Transaction, Xid> xidMapper) {
        Assert.checkNotNullParam((String)"transactionManagerSupplier", transactionManagerSupplier);
        Assert.checkNotNullParam((String)"xidMapper", xidMapper);
        this.transactionManagerSupplier = transactionManagerSupplier;
        this.xidMapper = xidMapper;
    }

    @Override
    public void handleInvocation(EJBClientInvocationContext context) throws Exception {
        ClientTransactionPolicy transactionPolicy = context.getTransactionPolicy();
        TransactionManager transactionManager = this.transactionManagerSupplier.get();
        Transaction transaction = TransactionInterceptor.safeGetTransaction(transactionManager);
        if (transactionPolicy.failIfTransactionAbsent() && transaction == null) {
            throw Logs.TXN.txNotActiveForThread();
        }
        if (transactionPolicy.failIfTransactionPresent() && transaction != null) {
            throw Logs.TXN.txAlreadyAssociatedWithThread();
        }
        if (transactionPolicy.propagate()) {
            context.setTransaction(transaction);
        }
        context.sendRequest();
    }

    private static Transaction safeGetTransaction(TransactionManager transactionManager) {
        try {
            return transactionManager == null ? null : transactionManager.getTransaction();
        }
        catch (SystemException e) {
            return null;
        }
    }

    @Override
    public Object handleInvocationResult(EJBClientInvocationContext context) throws Exception {
        return context.getResult();
    }
}

