/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.legacy;

import java.io.IOException;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.xml.bind.DatatypeConverter;
import org.jboss.ejb.client.legacy.PropertiesValueResolver;
import org.jboss.ejb.client.legacy.RemotingConnectionConfiguration;
import org.jboss.logging.Logger;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

public class LegacyPropertiesConfiguration {
    private static final Logger logger = Logger.getLogger(LegacyPropertiesConfiguration.class);
    private static final String PROPERTY_KEY_ENDPOINT_NAME = "endpoint.name";
    private static final String DEFAULT_ENDPOINT_NAME = "config-based-ejb-client-endpoint";
    private static final String PROPERTY_KEY_INVOCATION_TIMEOUT = "invocation.timeout";
    private static final String PROPERTY_KEY_RECONNECT_TASKS_TIMEOUT = "reconnect.tasks.timeout";
    private static final String ENDPOINT_CREATION_OPTIONS_PREFIX = "endpoint.create.options.";
    private static final OptionMap DEFAULT_ENDPOINT_CREATION_OPTIONS = OptionMap.create((Option)Options.THREAD_DAEMON, (Object)true);
    private static final OptionMap DEFAULT_CONNECTION_PROVIDER_CREATION_OPTIONS = OptionMap.EMPTY;
    private static final String REMOTE_CONNECTION_PROVIDER_CREATE_OPTIONS_PREFIX = "remote.connectionprovider.create.options.";
    private static final String PROPERTY_KEY_REMOTE_CONNECTIONS = "remote.connections";
    private static final String PROPERTY_KEY_REMOTE_CONNECTIONS_CONNECT_EAGER = "remote.connections.connect.eager";
    private static final OptionMap DEFAULT_CONNECTION_CREATION_OPTIONS = OptionMap.EMPTY;
    private static final long DEFAULT_CONNECTION_TIMEOUT_IN_MILLIS = 5000L;
    private static final String PROPERTY_KEY_USERNAME = "username";
    private static final String PROPERTY_KEY_PASSWORD = "password";
    private static final String PROPERTY_KEY_PASSWORD_BASE64 = "password.base64";
    private static final String PROPERTY_KEY_REALM = "realm";
    private static final String PROPERTY_KEY_CALLBACK_HANDLER_CLASS = "callback.handler.class";
    private static final String DEFAULT_PROTOCOL = "http-remoting";
    private final Properties ejbReceiversConfigurationProperties;
    private String endPointName;
    private OptionMap endPointCreationOptions;
    private OptionMap remoteConnectionProviderCreationOptions;
    private CallbackHandler callbackHandler;
    private Collection<RemotingConnectionConfiguration> remotingConnectionConfigurations = new ArrayList<RemotingConnectionConfiguration>();
    private long invocationTimeout = 0L;
    private long reconnectTasksTimeout = 0L;
    private static final boolean expandPasswords = Boolean.valueOf(System.getProperty("jboss-ejb-client.expandPasswords", "false"));

    public LegacyPropertiesConfiguration(Properties properties) {
        Properties resolvedProperties = new Properties();
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof String) {
                    boolean propertyIsAPassword;
                    boolean bl = propertyIsAPassword = ((String)entry.getKey()).indexOf(PROPERTY_KEY_PASSWORD) >= 0;
                    if (!propertyIsAPassword || propertyIsAPassword && expandPasswords) {
                        value = PropertiesValueResolver.replaceProperties((String)value);
                    }
                }
                resolvedProperties.put(entry.getKey(), value);
            }
        }
        this.ejbReceiversConfigurationProperties = resolvedProperties;
        this.parseProperties();
    }

    public String getEndpointName() {
        return this.endPointName;
    }

    public OptionMap getEndpointCreationOptions() {
        return this.endPointCreationOptions;
    }

    public OptionMap getRemoteConnectionProviderCreationOptions() {
        return this.remoteConnectionProviderCreationOptions;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public Collection<RemotingConnectionConfiguration> getConnectionConfigurations() {
        return this.remotingConnectionConfigurations;
    }

    public long getInvocationTimeout() {
        return this.invocationTimeout;
    }

    public long getReconnectTasksTimeout() {
        return this.reconnectTasksTimeout;
    }

    private void parseProperties() {
        String reconnectTasksTimeoutValue;
        this.endPointName = this.ejbReceiversConfigurationProperties.getProperty(PROPERTY_KEY_ENDPOINT_NAME, DEFAULT_ENDPOINT_NAME);
        OptionMap endPointCreationOptionsFromConfiguration = this.getOptionMapFromProperties(this.ejbReceiversConfigurationProperties, ENDPOINT_CREATION_OPTIONS_PREFIX, LegacyPropertiesConfiguration.getClientClassLoader());
        this.endPointCreationOptions = this.mergeWithDefaults(DEFAULT_ENDPOINT_CREATION_OPTIONS, endPointCreationOptionsFromConfiguration);
        String invocationTimeoutValue = this.ejbReceiversConfigurationProperties.getProperty(PROPERTY_KEY_INVOCATION_TIMEOUT);
        if (invocationTimeoutValue != null && !invocationTimeoutValue.trim().isEmpty()) {
            try {
                this.invocationTimeout = Long.parseLong(invocationTimeoutValue.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((reconnectTasksTimeoutValue = this.ejbReceiversConfigurationProperties.getProperty(PROPERTY_KEY_RECONNECT_TASKS_TIMEOUT)) != null && !reconnectTasksTimeoutValue.trim().isEmpty()) {
            try {
                this.reconnectTasksTimeout = Long.parseLong(reconnectTasksTimeoutValue.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        OptionMap remoteConnectionProviderOptionsFromConfiguration = this.getOptionMapFromProperties(this.ejbReceiversConfigurationProperties, REMOTE_CONNECTION_PROVIDER_CREATE_OPTIONS_PREFIX, LegacyPropertiesConfiguration.getClientClassLoader());
        this.remoteConnectionProviderCreationOptions = this.mergeWithDefaults(DEFAULT_CONNECTION_PROVIDER_CREATION_OPTIONS, remoteConnectionProviderOptionsFromConfiguration);
        this.parseConnectionConfigurations();
    }

    private OptionMap getOptionMapFromProperties(Properties properties, String propertyPrefix, ClassLoader classLoader) {
        OptionMap.Builder optionMapBuilder = OptionMap.builder().parseAll(properties, propertyPrefix, classLoader);
        OptionMap optionMap = optionMapBuilder.getMap();
        logger.debugf("%s has the following options %s", (Object)propertyPrefix, (Object)optionMap);
        return optionMap;
    }

    private OptionMap mergeWithDefaults(OptionMap defaults, OptionMap overrides) {
        OptionMap.Builder combinedOptionsBuilder = OptionMap.builder().addAll(overrides);
        for (Option defaultOption : defaults) {
            if (combinedOptionsBuilder.getMap().contains(defaultOption)) continue;
            Object defaultValue = defaults.get(defaultOption);
            combinedOptionsBuilder.set(defaultOption, defaultValue);
        }
        OptionMap combinedOptions = combinedOptionsBuilder.getMap();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Options " + overrides + " have been merged with defaults " + defaults + " to form " + combinedOptions));
        }
        return combinedOptions;
    }

    private static ClassLoader getClientClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }

    private void parseConnectionConfigurations() {
        String remoteConnectionNames = (String)this.ejbReceiversConfigurationProperties.get(PROPERTY_KEY_REMOTE_CONNECTIONS);
        if (remoteConnectionNames == null || remoteConnectionNames.trim().isEmpty()) {
            logger.debug((Object)"No remoting connections configured in properties");
            return;
        }
        Object connectEagerValue = this.ejbReceiversConfigurationProperties.get(PROPERTY_KEY_REMOTE_CONNECTIONS_CONNECT_EAGER);
        boolean connectEager = connectEagerValue == null ? true : (connectEagerValue instanceof String ? Boolean.valueOf(((String)connectEagerValue).trim()) : true);
        StringTokenizer tokenizer = new StringTokenizer(remoteConnectionNames, ",");
        while (tokenizer.hasMoreTokens()) {
            String connectionName = tokenizer.nextToken().trim();
            if (connectionName.isEmpty()) continue;
            RemotingConnectionConfiguration connectionConfiguration = null;
            try {
                connectionConfiguration = this.createConnectionConfiguration(connectionName, connectEager);
            }
            catch (Exception e) {
                logger.warn((Object)("Could not create connection for connection named " + connectionName), (Throwable)e);
            }
            if (connectionConfiguration == null) continue;
            logger.debugf("Connection %s successfully created for connection named %s", (Object)connectionConfiguration, (Object)connectionName);
            this.remotingConnectionConfigurations.add(connectionConfiguration);
        }
    }

    private RemotingConnectionConfiguration createConnectionConfiguration(String connectionName, boolean defaultConnectEager) throws IOException, URISyntaxException {
        String connectEagerValue;
        Integer port;
        String connectionSpecificPrefix = this.getConnectionSpecificPrefix(connectionName);
        Map<String, String> connectionSpecificProps = this.getPropertiesWithPrefix(connectionSpecificPrefix);
        if (connectionSpecificProps.isEmpty()) {
            return null;
        }
        String host = connectionSpecificProps.get("host");
        if (host == null || host.trim().isEmpty()) {
            return null;
        }
        String portStringVal = connectionSpecificProps.get("port");
        if (portStringVal == null || portStringVal.trim().isEmpty()) {
            return null;
        }
        try {
            port = Integer.parseInt(portStringVal.trim());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        String protocol = connectionSpecificProps.get("protocol");
        if (protocol == null) {
            protocol = DEFAULT_PROTOCOL;
        }
        String connectOptionsPrefix = this.getConnectionSpecificConnectOptionsPrefix(connectionName);
        OptionMap connectOptionsFromConfiguration = this.getOptionMapFromProperties(this.ejbReceiversConfigurationProperties, connectOptionsPrefix, LegacyPropertiesConfiguration.getClientClassLoader());
        OptionMap connectOptions = this.mergeWithDefaults(DEFAULT_CONNECTION_CREATION_OPTIONS, connectOptionsFromConfiguration);
        long connectionTimeout = 5000L;
        String connectionTimeoutValue = connectionSpecificProps.get("connect.timeout");
        if (connectionTimeoutValue != null && !connectionTimeoutValue.trim().isEmpty()) {
            try {
                connectionTimeout = Long.parseLong(connectionTimeoutValue.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        boolean connectEagerly = (connectEagerValue = connectionSpecificProps.get("connect.eager")) == null || connectEagerValue.trim().isEmpty() ? defaultConnectEager : Boolean.valueOf(connectEagerValue.trim());
        String channelOptionsPrefix = this.getConnectionSpecificChannelOptionsPrefix(connectionName);
        OptionMap channelOptions = this.getOptionMapFromProperties(this.ejbReceiversConfigurationProperties, channelOptionsPrefix, LegacyPropertiesConfiguration.getClientClassLoader());
        return new RemotingConnectionConfigurationImpl(protocol, host, port, connectOptions, connectionTimeout, this.callbackHandler, channelOptions, connectEagerly);
    }

    private String getConnectionSpecificPrefix(String connectionName) {
        return "remote.connection." + connectionName + ".";
    }

    private String getConnectionSpecificConnectOptionsPrefix(String connectionName) {
        return "remote.connection." + connectionName + ".connect.options.";
    }

    private String getConnectionSpecificChannelOptionsPrefix(String connectionName) {
        return "remote.connection." + connectionName + ".channel.options.";
    }

    private Map<String, String> getPropertiesWithPrefix(String prefix) {
        HashMap<String, String> propertiesWithPrefix = new HashMap<String, String>();
        for (String fullPropName : this.ejbReceiversConfigurationProperties.stringPropertyNames()) {
            if (!fullPropName.startsWith(prefix)) continue;
            String propName = fullPropName.substring(prefix.length());
            String propValue = this.ejbReceiversConfigurationProperties.getProperty(fullPropName);
            propertiesWithPrefix.put(propName, propValue);
        }
        return propertiesWithPrefix;
    }

    private CallbackHandler createCallbackHandler(Map<String, String> properties, CallbackHandler defaultCallbackHandler) {
        String realm;
        String passwordBase64;
        String password;
        String userName;
        String callbackClass = properties.get(PROPERTY_KEY_CALLBACK_HANDLER_CLASS);
        CallbackHandler handler = this.resolveCallbackHandler(callbackClass, userName = properties.get(PROPERTY_KEY_USERNAME), password = properties.get(PROPERTY_KEY_PASSWORD), passwordBase64 = properties.get(PROPERTY_KEY_PASSWORD_BASE64), realm = properties.get(PROPERTY_KEY_REALM));
        if (handler != null) {
            return handler;
        }
        return defaultCallbackHandler;
    }

    private CallbackHandler resolveCallbackHandler(String callbackClass, String userName, String password, String passwordBase64, String realm) {
        if (callbackClass == null || userName != null || password != null) {
            // empty if block
        }
        if (callbackClass != null) {
            ClassLoader classLoader = LegacyPropertiesConfiguration.getClientClassLoader();
            try {
                Class<?> clazz = Class.forName(callbackClass, true, classLoader);
                return (CallbackHandler)clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (userName != null) {
            String decodedPassword;
            if (password == null || passwordBase64 != null) {
                // empty if block
            }
            if (passwordBase64 != null) {
                decodedPassword = DatatypeConverter.printBase64Binary((byte[])passwordBase64.getBytes());
            } else {
                decodedPassword = password != null ? password : null;
            }
            return new AuthenticationCallbackHandler(userName, decodedPassword == null ? null : decodedPassword.toCharArray(), realm);
        }
        return null;
    }

    private class RemotingConnectionConfigurationImpl
    implements RemotingConnectionConfiguration {
        final String protocol;
        final String host;
        final int port;
        final OptionMap connectionCreationOptions;
        final long connectionTimeout;
        final CallbackHandler callbackHandler;
        final OptionMap channelCreationOptions;
        final boolean connectEagerly;

        RemotingConnectionConfigurationImpl(String protocol, String host, int port, OptionMap connectionCreationOptions, long connectionTimeout, CallbackHandler callbackHandler, OptionMap channelCreationOptions, boolean connectEagerly) {
            this.protocol = protocol;
            this.host = host;
            this.port = port;
            this.connectionCreationOptions = connectionCreationOptions;
            this.connectionTimeout = connectionTimeout;
            this.callbackHandler = callbackHandler;
            this.channelCreationOptions = channelCreationOptions == null ? OptionMap.EMPTY : channelCreationOptions;
            this.connectEagerly = connectEagerly;
        }

        @Override
        public String getHost() {
            return this.host;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public long getConnectionTimeout() {
            return this.connectionTimeout;
        }

        @Override
        public OptionMap getConnectionCreationOptions() {
            return this.connectionCreationOptions;
        }

        @Override
        public CallbackHandler getCallbackHandler() {
            return this.callbackHandler;
        }

        @Override
        public OptionMap getChannelCreationOptions() {
            return this.channelCreationOptions;
        }

        @Override
        public boolean isConnectEagerly() {
            return this.connectEagerly;
        }

        @Override
        public String getProtocol() {
            return this.protocol;
        }
    }

    private class AuthenticationCallbackHandler
    implements CallbackHandler {
        private final String realm;
        private final String username;
        private final char[] password;

        private AuthenticationCallbackHandler(String username, char[] password, String realm) {
            this.username = username;
            this.password = password;
            this.realm = realm;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (current instanceof RealmCallback) {
                    RealmCallback rcb = (RealmCallback)current;
                    if (this.realm == null) {
                        String defaultText = rcb.getDefaultText();
                        rcb.setText(defaultText);
                        continue;
                    }
                    rcb.setText(this.realm);
                    continue;
                }
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName(this.username);
                    continue;
                }
                if (current instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)current;
                    pcb.setPassword(this.password);
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuthenticationCallbackHandler that = (AuthenticationCallbackHandler)o;
            if (!Arrays.equals(this.password, that.password)) {
                return false;
            }
            if (this.realm != null ? !this.realm.equals(that.realm) : that.realm != null) {
                return false;
            }
            return !(this.username != null ? !this.username.equals(that.username) : that.username != null);
        }

        public int hashCode() {
            int result = this.realm != null ? this.realm.hashCode() : 0;
            result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
            result = 31 * result + (this.password != null ? Arrays.hashCode(this.password) : 0);
            return result;
        }
    }
}

