/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.legacy;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.Properties;
import org.jboss.ejb._private.Logs;
import org.jboss.logging.Logger;

public class LegacyPropertiesLoader {
    private static final Logger logger = Logger.getLogger(LegacyPropertiesLoader.class);
    private static final String EJB_CLIENT_PROPS_FILE_SYS_PROPERTY = "jboss.ejb.client.properties.file.path";
    private static final String EJB_CLIENT_PROPS_SKIP_CLASSLOADER_SCAN_SYS_PROPERTY = "jboss.ejb.client.properties.skip.classloader.scan";
    private static final String EJB_CLIENT_PROPS_FILE_NAME = "jboss-ejb-client.properties";

    public static Properties loadEJBClientProperties() {
        String ejbClientPropsFilePath = LegacyPropertiesLoader.getSystemProperty(EJB_CLIENT_PROPS_FILE_SYS_PROPERTY);
        if (ejbClientPropsFilePath != null) {
            FileInputStream fileStream = null;
            try {
                fileStream = new FileInputStream(ejbClientPropsFilePath);
                Properties ejbClientProps = new Properties();
                ejbClientProps.load(fileStream);
                Properties properties = ejbClientProps;
                return properties;
            }
            catch (FileNotFoundException e) {
                throw Logs.MAIN.failedToFindEjbClientConfigFileSpecifiedBySysProp(e, EJB_CLIENT_PROPS_FILE_SYS_PROPERTY);
            }
            catch (IOException e) {
                throw Logs.MAIN.failedToReadEjbClientConfigFile(e, ejbClientPropsFilePath);
            }
            finally {
                if (fileStream != null) {
                    try {
                        ((InputStream)fileStream).close();
                    }
                    catch (IOException e) {
                        logger.error((Object)("Failed to close file " + ejbClientPropsFilePath), (Throwable)e);
                    }
                }
            }
        }
        String skipClasspathScan = LegacyPropertiesLoader.getSystemProperty(EJB_CLIENT_PROPS_SKIP_CLASSLOADER_SCAN_SYS_PROPERTY);
        if (skipClasspathScan != null && Boolean.valueOf(skipClasspathScan.trim()).booleanValue()) {
            logger.debugf("%s system property is set. Skipping classloader search for %s", (Object)EJB_CLIENT_PROPS_SKIP_CLASSLOADER_SCAN_SYS_PROPERTY, (Object)EJB_CLIENT_PROPS_FILE_NAME);
            return null;
        }
        ClassLoader classLoader = LegacyPropertiesLoader.getClientClassLoader();
        logger.debugf("Looking for %s using classloader %s", (Object)EJB_CLIENT_PROPS_FILE_NAME, (Object)classLoader);
        InputStream clientPropsInputStream = classLoader.getResourceAsStream(EJB_CLIENT_PROPS_FILE_NAME);
        if (clientPropsInputStream != null) {
            logger.debugf("Found %s using classloader %s", (Object)EJB_CLIENT_PROPS_FILE_NAME, (Object)classLoader);
            Properties clientProps = new Properties();
            try {
                clientProps.load(clientPropsInputStream);
                Properties properties = clientProps;
                return properties;
            }
            catch (IOException e) {
                throw Logs.MAIN.failedToReadEjbClientConfigFile(e, EJB_CLIENT_PROPS_FILE_NAME);
            }
            finally {
                try {
                    clientPropsInputStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Failed to close stream", (Throwable)e);
                }
            }
        }
        return null;
    }

    private static ClassLoader getClientClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        ClassLoader classLoader = sm != null ? AccessController.doPrivileged(LegacyPropertiesLoader::doGetContextClassLoader) : LegacyPropertiesLoader.doGetContextClassLoader();
        return classLoader;
    }

    private static ClassLoader doGetContextClassLoader() {
        return LegacyPropertiesLoader.class.getClassLoader();
    }

    private static String getSystemProperty(String key) {
        SecurityManager sm = System.getSecurityManager();
        String value = sm != null ? AccessController.doPrivileged(() -> System.getProperty(key)) : System.getProperty(key);
        return value;
    }
}

