/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import javax.transaction.UserTransaction;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientPermission;
import org.jboss.ejb.client.EJBInvocationHandler;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBMethodLocator;
import org.jboss.ejb.client.EJBProxyInformation;
import org.jboss.ejb.client.FinishedFuture;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.ejb.client.Version;
import org.wildfly.common.Assert;
import org.wildfly.discovery.FilterSpec;
import org.wildfly.discovery.ServicesQueue;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.transaction.client.RemoteTransactionContext;

public final class EJBClient {
    private static final Logs log = Logs.MAIN;
    private static final ThreadLocal<Future<?>> FUTURE_RESULT;

    private EJBClient() {
    }

    public static <T> T asynchronous(T proxy) throws IllegalArgumentException {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(proxy);
        if (invocationHandler instanceof EJBInvocationHandler) {
            EJBInvocationHandler remoteInvocationHandler = (EJBInvocationHandler)invocationHandler;
            if (remoteInvocationHandler.isAsyncHandler()) {
                return proxy;
            }
            return (T)Proxy.newProxyInstance(proxy.getClass().getClassLoader(), proxy.getClass().getInterfaces(), remoteInvocationHandler.getAsyncHandler());
        }
        throw log.unknownProxy(proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Future<T> getFutureResult(T operation) throws IllegalStateException {
        if (operation != null) {
            return new FinishedFuture<T>(operation);
        }
        ThreadLocal<Future<?>> futureResult = FUTURE_RESULT;
        try {
            Future<?> future = futureResult.get();
            if (future == null) {
                throw log.noAsyncInProgress();
            }
            Future<?> future2 = future;
            return future2;
        }
        finally {
            futureResult.remove();
        }
    }

    public static Future<?> getFutureResult() throws IllegalStateException {
        ThreadLocal<Future<?>> futureResult = FUTURE_RESULT;
        try {
            Future<?> future = futureResult.get();
            if (future == null) {
                throw log.noAsyncInProgress();
            }
            Future<?> future2 = future;
            return future2;
        }
        finally {
            futureResult.remove();
        }
    }

    static void setFutureResult(Future<?> future) {
        FUTURE_RESULT.set(future);
    }

    public static <T> T createProxy(EJBLocator<T> locator) throws IllegalArgumentException {
        return EJBClient.createProxy(null, locator);
    }

    static <T> T createProxy(NamingProvider namingProvider, EJBLocator<T> locator) throws IllegalArgumentException {
        Assert.checkNotNullParam((String)"locator", locator);
        return locator.createProxyInstance(new EJBInvocationHandler<T>(namingProvider, locator));
    }

    public static boolean isEJBProxy(Object object) {
        return object != null && Proxy.isProxyClass(object.getClass()) && Proxy.getInvocationHandler(object) instanceof EJBInvocationHandler;
    }

    public static <T> StatefulEJBLocator<T> createSession(Class<T> viewType, String appName, String moduleName, String beanName, String distinctName) throws Exception {
        return EJBClient.createSession(new StatelessEJBLocator<T>(viewType, appName, moduleName, beanName, distinctName, Affinity.NONE));
    }

    public static <T> StatefulEJBLocator<T> createSession(Affinity affinity, Class<T> viewType, String appName, String moduleName, String beanName, String distinctName) throws Exception {
        return EJBClient.createSession(new StatelessEJBLocator<T>(viewType, appName, moduleName, beanName, distinctName, affinity == null ? Affinity.NONE : affinity));
    }

    public static <T> StatefulEJBLocator<T> createSession(URI uri, Class<T> viewType, String appName, String moduleName, String beanName, String distinctName) throws Exception {
        Affinity affinity = uri == null ? Affinity.NONE : Affinity.forUri(uri);
        return EJBClient.createSession(new StatelessEJBLocator<T>(viewType, appName, moduleName, beanName, distinctName, affinity));
    }

    public static <T> StatefulEJBLocator<T> createSession(Class<T> viewType, String appName, String moduleName, String beanName) throws Exception {
        return EJBClient.createSession(new StatelessEJBLocator<T>(viewType, appName, moduleName, beanName, Affinity.NONE));
    }

    public static <T> StatefulEJBLocator<T> createSession(Affinity affinity, Class<T> viewType, String appName, String moduleName, String beanName) throws Exception {
        return EJBClient.createSession(new StatelessEJBLocator<T>(viewType, appName, moduleName, beanName, affinity == null ? Affinity.NONE : affinity));
    }

    public static <T> StatefulEJBLocator<T> createSession(URI uri, Class<T> viewType, String appName, String moduleName, String beanName) throws Exception {
        Affinity affinity = uri == null ? Affinity.NONE : Affinity.forUri(uri);
        return EJBClient.createSession(new StatelessEJBLocator<T>(viewType, appName, moduleName, beanName, affinity));
    }

    public static <T> StatefulEJBLocator<T> createSession(StatelessEJBLocator<T> statelessLocator) throws Exception {
        EJBClientContext clientContext = EJBClientContext.getCurrent();
        return clientContext.createSession(statelessLocator);
    }

    public static <T> void invokeOneWay(T proxy, EJBMethodLocator methodLocator, Object ... args) throws Exception {
        EJBInvocationHandler<T> invocationHandler = EJBInvocationHandler.forProxy(proxy);
        EJBProxyInformation.ProxyMethodInfo proxyMethodInfo = invocationHandler.getProxyMethodInfo(methodLocator);
        invocationHandler.invoke(proxy, proxyMethodInfo, args);
    }

    public static <T> Future<?> invokeAsync(T proxy, EJBMethodLocator methodLocator, Object ... args) throws Exception {
        EJBInvocationHandler<T> invocationHandler = EJBInvocationHandler.forProxy(proxy);
        EJBProxyInformation.ProxyMethodInfo proxyMethodInfo = invocationHandler.getProxyMethodInfo(methodLocator);
        return (Future)invocationHandler.invoke(proxy, proxyMethodInfo, args);
    }

    public static <T> Object invoke(T proxy, EJBMethodLocator methodLocator, Object ... args) throws Exception {
        EJBInvocationHandler<T> invocationHandler = EJBInvocationHandler.forProxy(proxy);
        EJBProxyInformation.ProxyMethodInfo proxyMethodInfo = invocationHandler.getProxyMethodInfo(methodLocator);
        return invocationHandler.invoke(proxy, proxyMethodInfo, args);
    }

    public static <T> EJBLocator<? extends T> getLocatorFor(T proxy) throws IllegalArgumentException {
        Assert.checkNotNullParam((String)"proxy", proxy);
        return EJBInvocationHandler.forProxy(proxy).getLocator();
    }

    public static void setInvocationTimeout(Object proxy, long timeout, TimeUnit timeUnit) throws IllegalArgumentException {
        Assert.checkNotNullParam((String)"proxy", (Object)proxy);
        Assert.checkMinimumParameter((String)"timeout", (long)1L, (long)timeout);
        Assert.checkNotNullParam((String)"timeUnit", (Object)((Object)timeUnit));
        EJBInvocationHandler.forProxy(proxy).setInvocationTimeout(Math.max(1L, timeUnit.toMillis(timeout)));
    }

    public static void clearInvocationTimeout(Object proxy) throws IllegalArgumentException {
        Assert.checkNotNullParam((String)"proxy", (Object)proxy);
        EJBInvocationHandler.forProxy(proxy).setInvocationTimeout(-1L);
    }

    public static void setStrongAffinity(Object proxy, Affinity newAffinity) throws IllegalArgumentException, SecurityException {
        Assert.checkNotNullParam((String)"proxy", (Object)proxy);
        Assert.checkNotNullParam((String)"newAffinity", (Object)newAffinity);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new EJBClientPermission(EJBClientPermission.Name.changeStrongAffinity));
        }
        EJBInvocationHandler.forProxy(proxy).setStrongAffinity(newAffinity);
    }

    public static Affinity getStrongAffinity(Object proxy) throws IllegalArgumentException {
        Assert.checkNotNullParam((String)"proxy", (Object)proxy);
        return EJBClient.getLocatorFor(proxy).getAffinity();
    }

    public static boolean compareAndSetStrongAffinity(Object proxy, Affinity expectedAffinity, Affinity newAffinity) throws IllegalArgumentException, SecurityException {
        Assert.checkNotNullParam((String)"proxy", (Object)proxy);
        Assert.checkNotNullParam((String)"expectedAffinity", (Object)expectedAffinity);
        Assert.checkNotNullParam((String)"newAffinity", (Object)newAffinity);
        EJBInvocationHandler<Object> invocationHandler = EJBInvocationHandler.forProxy(proxy);
        Affinity existing = invocationHandler.getLocator().getAffinity();
        if (!expectedAffinity.equals(existing)) {
            return false;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new EJBClientPermission(EJBClientPermission.Name.changeStrongAffinity));
        }
        return invocationHandler.compareAndSetStrongAffinity(expectedAffinity, newAffinity);
    }

    public static void transformStrongAffinity(Object proxy, UnaryOperator<Affinity> transformOperator) throws IllegalArgumentException, SecurityException {
        Assert.checkNotNullParam((String)"proxy", (Object)proxy);
        Assert.checkNotNullParam((String)"transformOperator", transformOperator);
        EJBInvocationHandler<Object> invocationHandler = EJBInvocationHandler.forProxy(proxy);
        Affinity oldAffinity = invocationHandler.getLocator().getAffinity();
        Affinity newAffinity = (Affinity)transformOperator.apply(oldAffinity);
        Assert.assertNotNull((Object)newAffinity);
        if (oldAffinity.equals(newAffinity)) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new EJBClientPermission(EJBClientPermission.Name.changeStrongAffinity));
        }
        while (!invocationHandler.compareAndSetStrongAffinity(oldAffinity, newAffinity)) {
            oldAffinity = invocationHandler.getLocator().getAffinity();
            newAffinity = (Affinity)transformOperator.apply(oldAffinity);
            Assert.assertNotNull((Object)newAffinity);
            if (!oldAffinity.equals(newAffinity)) continue;
            return;
        }
    }

    public static void setWeakAffinity(Object proxy, Affinity newAffinity) throws IllegalArgumentException, SecurityException {
        Assert.checkNotNullParam((String)"proxy", (Object)proxy);
        Assert.checkNotNullParam((String)"newAffinity", (Object)newAffinity);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new EJBClientPermission(EJBClientPermission.Name.changeWeakAffinity));
        }
        EJBInvocationHandler.forProxy(proxy).setWeakAffinity(newAffinity);
    }

    public static Affinity getWeakAffinity(Object proxy) throws IllegalArgumentException {
        Assert.checkNotNullParam((String)"proxy", (Object)proxy);
        return EJBInvocationHandler.forProxy(proxy).getWeakAffinity();
    }

    public static void convertToStateful(Object proxy, SessionID sessionID) throws IllegalArgumentException {
        Assert.checkNotNullParam((String)"proxy", (Object)proxy);
        Assert.checkNotNullParam((String)"sessionID", (Object)sessionID);
        EJBInvocationHandler.forProxy(proxy).setSessionID(sessionID);
    }

    @Deprecated
    public static UserTransaction getUserTransaction(String targetNodeName) {
        URI uri;
        try (ServicesQueue queue = EJBClientContext.getCurrent().getDiscovery().discover(EJBClientContext.EJB_SERVICE_TYPE, FilterSpec.equal((String)"node", (String)targetNodeName));){
            uri = queue.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        return RemoteTransactionContext.getInstance().getUserTransaction(uri);
    }

    static {
        log.greeting(Version.getVersionString());
        FUTURE_RESULT = new ThreadLocal();
    }
}

