/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.transaction.Transaction;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.AbstractInvocationContext;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInterceptorInformation;
import org.jboss.ejb.client.EJBInvocationHandler;
import org.jboss.ejb.client.EJBMethodLocator;
import org.jboss.ejb.client.EJBProxyInformation;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.annotation.ClientTransactionPolicy;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;

public final class EJBClientInvocationContext
extends AbstractInvocationContext {
    private static final Logs log = Logs.MAIN;
    public static final String PRIVATE_ATTACHMENTS_KEY = "org.jboss.ejb.client.invocation.attachments";
    private final EJBInvocationHandler<?> invocationHandler;
    private final AuthenticationContext authenticationContext;
    private final Object invokedProxy;
    private final Object[] parameters;
    private final EJBProxyInformation.ProxyMethodInfo methodInfo;
    private final EJBReceiverInvocationContext receiverInvocationContext = new EJBReceiverInvocationContext(this);
    private final EJBClientContext.InterceptorList interceptorList;
    private final long startTime = System.nanoTime();
    private final long timeout;
    private final Object lock = new Object();
    private EJBReceiverInvocationContext.ResultProducer resultProducer;
    private volatile boolean cancelRequested;
    private boolean retryRequested;
    private State state = State.SENDING;
    private int remainingRetries;
    private Supplier<? extends Throwable> pendingFailure;
    private List<Supplier<? extends Throwable>> suppressedExceptions;
    private Object cachedResult;
    private int interceptorChainIndex;
    private boolean blockingCaller;
    private Transaction transaction;
    private AuthenticationConfiguration authenticationConfiguration;
    private SSLContext sslContext;
    static final Supplier<Throwable> CANCELLED_PRODUCER = Logs.INVOCATION::requestCancelled;
    static final ThrowableResult CANCELLED = new ThrowableResult(CANCELLED_PRODUCER);
    static final ThrowableResult ONE_WAY = new ThrowableResult(Logs.INVOCATION::oneWayInvocation);

    EJBClientInvocationContext(EJBInvocationHandler<?> invocationHandler, EJBClientContext ejbClientContext, Object invokedProxy, Object[] parameters, EJBProxyInformation.ProxyMethodInfo methodInfo, int allowedRetries) {
        super(invocationHandler.getLocator(), ejbClientContext);
        this.invocationHandler = invocationHandler;
        this.authenticationContext = AuthenticationContext.captureCurrent();
        this.invokedProxy = invokedProxy;
        this.parameters = parameters;
        this.methodInfo = methodInfo;
        long timeout = invocationHandler.getInvocationTimeout();
        if (timeout == -1L) {
            timeout = ejbClientContext.getInvocationTimeout();
        }
        this.timeout = timeout;
        this.remainingRetries = allowedRetries;
        this.interceptorList = this.getClientContext().getInterceptors(this.getViewClass(), this.getInvokedMethod());
    }

    public <T> T getProxyAttachment(AttachmentKey<T> key) {
        return this.invocationHandler.getAttachment(key);
    }

    public <T> T removeProxyAttachment(AttachmentKey<T> key) {
        return this.invocationHandler.removeAttachment(key);
    }

    public boolean isClientAsync() {
        return this.invocationHandler.isAsyncHandler() || this.methodInfo.isClientAsync();
    }

    public boolean isSynchronous() {
        return !this.isClientAsync() && this.methodInfo.isSynchronous();
    }

    public boolean isIdempotent() {
        return this.methodInfo.isIdempotent();
    }

    public ClientTransactionPolicy getTransactionPolicy() {
        return this.methodInfo.getTransactionPolicy();
    }

    public boolean isCompressRequest() {
        return this.methodInfo.isCompressRequest();
    }

    public boolean isCompressResponse() {
        return this.methodInfo.isCompressResponse();
    }

    public int getCompressionLevel() {
        return this.methodInfo.getCompressionLevel();
    }

    public String getMethodSignatureString() {
        return this.methodInfo.getSignature();
    }

    public EJBMethodLocator getMethodLocator() {
        return this.methodInfo.getMethodLocator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlockingCaller() {
        Object object = this.lock;
        synchronized (object) {
            return this.blockingCaller;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlockingCaller(boolean blockingCaller) {
        Object object = this.lock;
        synchronized (object) {
            this.blockingCaller = blockingCaller;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSuppressed(Throwable cause) {
        Assert.checkNotNullParam((String)"cause", (Object)cause);
        Object object = this.lock;
        synchronized (object) {
            if (this.state == State.DONE) {
                return;
            }
            if (this.suppressedExceptions == null) {
                this.suppressedExceptions = new ArrayList<Supplier<? extends Throwable>>();
            }
            this.suppressedExceptions.add(() -> cause);
            this.checkStateInvariants();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSuppressed(Supplier<? extends Throwable> cause) {
        Assert.checkNotNullParam((String)"cause", cause);
        Object object = this.lock;
        synchronized (object) {
            if (this.state == State.DONE) {
                return;
            }
            if (this.suppressedExceptions == null) {
                this.suppressedExceptions = new ArrayList<Supplier<? extends Throwable>>();
            }
            this.suppressedExceptions.add(cause);
            this.checkStateInvariants();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestRetry() {
        Object object = this.lock;
        synchronized (object) {
            this.retryRequested = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void sendRequestInitial() {
        assert (this.checkState() == State.SENDING);
        while (true) {
            assert (this.interceptorChainIndex == 0);
            try {
                this.authenticationContext.runExConsumer(EJBClientInvocationContext::sendRequest, (Object)this);
                Object object = this.lock;
                synchronized (object) {
                    try {
                        assert (this.state == State.SENT);
                        Supplier<? extends Throwable> pendingFailure = this.pendingFailure;
                        EJBReceiverInvocationContext.ResultProducer resultProducer = this.resultProducer;
                        if (resultProducer != null) {
                            if (pendingFailure != null) {
                                this.addSuppressed(pendingFailure);
                                this.pendingFailure = null;
                            }
                            this.transition(State.READY);
                            return;
                        }
                        if (pendingFailure != null) {
                            if (!this.retryRequested || this.remainingRetries == 0) {
                                this.resultProducer = new ThrowableResult(pendingFailure);
                                this.pendingFailure = null;
                                this.transition(State.READY);
                                return;
                            }
                            this.transition(State.SENDING);
                            this.retryRequested = false;
                            --this.remainingRetries;
                            this.addSuppressed(pendingFailure);
                            this.pendingFailure = null;
                            continue;
                        }
                        this.transition(State.WAITING);
                        return;
                    }
                    finally {
                        this.checkStateInvariants();
                    }
                }
            }
            catch (Throwable t) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.state == State.SENDING) {
                        this.transition(State.SENT);
                    }
                    assert (this.state == State.SENT);
                    try {
                        Supplier<? extends Throwable> pendingFailure = this.pendingFailure;
                        EJBReceiverInvocationContext.ResultProducer resultProducer = this.resultProducer;
                        if (resultProducer != null) {
                            if (pendingFailure != null) {
                                this.addSuppressed(t);
                                this.addSuppressed(pendingFailure);
                                this.pendingFailure = null;
                            }
                            this.transition(State.READY);
                            return;
                        }
                        if (!this.retryRequested || this.remainingRetries == 0) {
                            if (pendingFailure != null) {
                                this.addSuppressed(pendingFailure);
                            }
                            this.resultProducer = t instanceof Exception ? new EJBReceiverInvocationContext.ResultProducer.Failed((Exception)t) : new EJBReceiverInvocationContext.ResultProducer.Failed(new UndeclaredThrowableException(t));
                            this.pendingFailure = null;
                            this.transition(State.READY);
                            return;
                        }
                        if (pendingFailure != null) {
                            this.addSuppressed(pendingFailure);
                        }
                        this.setReceiver(null);
                        this.pendingFailure = null;
                        this.transition(State.SENDING);
                        this.retryRequested = false;
                        --this.remainingRetries;
                    }
                    finally {
                        this.checkStateInvariants();
                    }
                }
                this.addSuppressed(t);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    State checkState() {
        Object object = this.lock;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest() throws Exception {
        block41: {
            Object lock = this.lock;
            Assert.assertNotHoldsLock((Object)lock);
            EJBClientInterceptorInformation[] chain = this.interceptorList.getInformation();
            Object object = lock;
            synchronized (object) {
                if (this.state != State.SENDING) {
                    throw Logs.MAIN.sendRequestCalledDuringWrongPhase();
                }
            }
            int idx = this.interceptorChainIndex++;
            try {
                if (this.cancelRequested) {
                    Object object2 = lock;
                    synchronized (object2) {
                        this.transition(State.SENT);
                        this.resultReady(CANCELLED);
                        this.checkStateInvariants();
                        break block41;
                    }
                }
                if (chain.length == idx) {
                    EJBReceiver receiver;
                    URI destination = this.getDestination();
                    try {
                        receiver = this.getClientContext().resolveReceiver(destination, this.getLocator());
                    }
                    catch (Throwable t) {
                        Object object3 = lock;
                        synchronized (object3) {
                            if (this.state != State.SENT) {
                                this.transition(State.SENT);
                            }
                            this.checkStateInvariants();
                        }
                        throw t;
                    }
                    this.setReceiver(receiver);
                    Object t = lock;
                    synchronized (t) {
                        this.transition(State.SENT);
                        this.checkStateInvariants();
                    }
                    try {
                        receiver.processInvocation(this.receiverInvocationContext);
                        break block41;
                    }
                    catch (Throwable t2) {
                        Object object4 = lock;
                        synchronized (object4) {
                            if (this.state != State.SENT) {
                                this.transition(State.SENT);
                            }
                            this.checkStateInvariants();
                        }
                        throw t2;
                    }
                }
                try {
                    chain[idx].getInterceptorInstance().handleInvocation(this);
                }
                catch (Throwable t) {
                    Object object5 = lock;
                    synchronized (object5) {
                        if (this.state != State.SENT) {
                            this.transition(State.SENT);
                        }
                        this.checkStateInvariants();
                    }
                    throw t;
                }
                Object object6 = lock;
                synchronized (object6) {
                    try {
                        if (this.state != State.SENT) {
                            assert (this.state == State.SENDING);
                            this.transition(State.SENT);
                            throw Logs.INVOCATION.requestNotSent();
                        }
                    }
                    finally {
                        this.checkStateInvariants();
                    }
                }
            }
            finally {
                --this.interceptorChainIndex;
            }
        }
    }

    public Object getResult() throws Exception {
        return this.getResult(false);
    }

    /*
     * Exception decompiling
     */
    Object getResult(boolean retry) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void discardResult() throws IllegalStateException {
        this.resultReady(ONE_WAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resultReady(EJBReceiverInvocationContext.ResultProducer resultProducer) {
        Assert.checkNotNullParam((String)"resultProducer", (Object)resultProducer);
        Object object = this.lock;
        synchronized (object) {
            if (this.state.isWaiting() && this.resultProducer == null) {
                this.resultProducer = resultProducer;
                if (this.state == State.WAITING) {
                    this.transition(State.READY);
                }
                this.checkStateInvariants();
                return;
            }
            this.checkStateInvariants();
        }
        resultProducer.discardResult();
    }

    public Object getInvokedProxy() {
        return this.invokedProxy;
    }

    public Method getInvokedMethod() {
        return this.methodInfo.getMethod();
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public long getRemainingInvocationTime(TimeUnit timeUnit) {
        Assert.checkNotNullParam((String)"timeUnit", (Object)((Object)timeUnit));
        long timeout = this.timeout;
        if (timeout <= 0L) {
            return Long.MAX_VALUE;
        }
        return Math.max(0L, timeUnit.convert(timeout - (System.nanoTime() - this.startTime) / 1000000L, TimeUnit.MILLISECONDS));
    }

    AuthenticationConfiguration getAuthenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    void setAuthenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
        this.authenticationConfiguration = authenticationConfiguration;
    }

    SSLContext getSSLContext() {
        return this.sslContext;
    }

    void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    Future<?> getFutureResponse() {
        return new FutureResponse();
    }

    void proceedAsynchronously() {
        if (this.getInvokedMethod().getReturnType() == Void.TYPE) {
            this.resultReady(EJBReceiverInvocationContext.ResultProducer.NULL);
        }
    }

    private void transition(State newState) {
        Object lock = this.lock;
        Assert.assertHoldsLock((Object)lock);
        State oldState = this.state;
        log.tracef("Transitioning %s from %s to %s", this, (Object)oldState, (Object)newState);
        switch (oldState) {
            case SENDING: {
                assert (newState == State.SENT);
                break;
            }
            case SENT: {
                assert (newState == State.READY || newState == State.SENDING || newState == State.DONE || newState == State.WAITING);
                break;
            }
            case WAITING: {
                assert (newState == State.DONE || newState == State.READY || newState == State.CONSUMING);
                break;
            }
            case READY: {
                assert (newState == State.CONSUMING);
                break;
            }
            case CONSUMING: {
                assert (newState == State.SENDING || newState == State.DONE);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        switch (newState) {
            case READY: 
            case DONE: {
                this.remainingRetries = 0;
            }
            case WAITING: {
                lock.notifyAll();
            }
        }
        this.state = newState;
    }

    private void checkStateInvariants() {
        Object lock = this.lock;
        Assert.assertHoldsLock((Object)lock);
        State state = this.state;
        switch (state) {
            case SENDING: {
                assert (this.resultProducer == null && this.cachedResult == null && this.getReceiver() == null);
                break;
            }
            case SENT: {
                assert (this.cachedResult == null);
                break;
            }
            case WAITING: {
                assert (this.resultProducer == null && this.pendingFailure == null && this.cachedResult == null);
                break;
            }
            case READY: {
                assert (this.resultProducer != null && this.pendingFailure == null && this.cachedResult == null && this.remainingRetries == 0);
                break;
            }
            case CONSUMING: {
                assert (this.resultProducer != null && this.pendingFailure == null && this.cachedResult == null);
                break;
            }
            case DONE: {
                assert (this.resultProducer == null && (this.pendingFailure == null || this.pendingFailure != null && this.cachedResult == null) && this.remainingRetries == 0);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean awaitCancellationResult() {
        Object lock = this.lock;
        Assert.assertNotHoldsLock((Object)lock);
        Object object = lock;
        synchronized (object) {
            while (this.resultProducer != CANCELLED) {
                if (!this.state.isWaiting()) {
                    return false;
                }
                try {
                    this.checkStateInvariants();
                    lock.wait();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object awaitResponse() throws Exception {
        Assert.assertNotHoldsLock((Object)this.lock);
        intr = false;
        timedOut = false;
        try {
            block29: {
                lock = this.lock;
                timeout = this.timeout;
                var6_5 = lock;
                synchronized (var6_5) {
                    try {
                        block23: while (true) {
                            switch (1.$SwitchMap$org$jboss$ejb$client$EJBClientInvocationContext$State[this.state.ordinal()]) {
                                case 1: 
                                case 2: 
                                case 3: 
                                case 5: {
                                    if (timeout <= 0L) {
                                        try {
                                            this.checkStateInvariants();
                                            lock.wait();
                                        }
                                        catch (InterruptedException e) {
                                            intr = true;
                                        }
                                        continue block23;
                                    }
                                    remaining = Math.max(0L, timeout * 1000000L - Math.max(0L, System.nanoTime() - this.startTime));
                                    if (remaining == 0L) {
                                        timedOut = true;
                                        this.resultReady(new ThrowableResult((Supplier<Throwable>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$awaitResponse$3(long ), ()Ljava/lang/Throwable;)((long)timeout)));
                                        continue block23;
                                    }
                                    try {
                                        this.checkStateInvariants();
                                        lock.wait(remaining / 1000000L, (int)(remaining % 1000000L));
                                        continue block23;
                                    }
                                    catch (InterruptedException e) {
                                        intr = true;
                                        continue block23;
                                    }
                                }
                                case 4: {
                                    this.checkStateInvariants();
                                    ** break;
lbl37:
                                    // 1 sources

                                    break block29;
                                }
                                case 6: {
                                    this.checkStateInvariants();
                                    if (this.pendingFailure == null) {
                                        t = this.cachedResult;
                                        return t;
                                    }
                                    try {
                                        throw this.pendingFailure.get();
                                    }
                                    catch (Error | Exception e) {
                                        throw e;
                                    }
                                    catch (Throwable t) {
                                        throw new UndeclaredThrowableException(t);
                                    }
                                }
                                default: {
                                    throw new IllegalStateException();
                                }
                            }
                            break;
                        }
                    }
                    finally {
                        this.blockingCaller = false;
                    }
                }
            }
            var6_5 = this.getResult();
            return var6_5;
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
            if (timedOut && (receiver = this.getReceiver()) != null) {
                receiver.cancelInvocation(this.receiverInvocationContext, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDiscardResult() {
        EJBReceiverInvocationContext.ResultProducer resultProducer;
        Object lock = this.lock;
        assert (!Thread.holdsLock(lock));
        Object object = lock;
        synchronized (object) {
            resultProducer = this.resultProducer;
            this.resultProducer = EJBReceiverInvocationContext.ResultProducer.NULL;
            if (this.state == State.WAITING) {
                this.transition(State.DONE);
            }
            this.checkStateInvariants();
        }
        if (resultProducer != null) {
            resultProducer.discardResult();
        }
    }

    void cancelled() {
        this.resultReady(CANCELLED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void failed(Exception exception, Executor retryExecutor) {
        Object lock;
        Object object = lock = this.lock;
        synchronized (object) {
            switch (this.state) {
                case CONSUMING: 
                case DONE: {
                    return;
                }
                case SENDING: {
                    throw new IllegalStateException();
                }
                case SENT: {
                    Supplier<? extends Throwable> pendingFailure = this.pendingFailure;
                    if (pendingFailure != null) {
                        this.addSuppressed(pendingFailure);
                    }
                    this.pendingFailure = () -> exception;
                    return;
                }
                case READY: {
                    this.addSuppressed(exception);
                    return;
                }
                case WAITING: {
                    this.resultProducer = new ThrowableResult(() -> exception);
                    this.pendingFailure = null;
                    this.transition(State.CONSUMING);
                    this.checkStateInvariants();
                    break;
                }
                default: {
                    throw Assert.impossibleSwitchCase((Object)((Object)this.state));
                }
            }
        }
        retryExecutor.execute(this::retryOperation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retryOperation() {
        block5: {
            try {
                this.getResult(true);
            }
            catch (Throwable t) {
                boolean retry;
                Object object = this.lock;
                synchronized (object) {
                    retry = this.state == State.SENDING;
                }
                if (!retry) break block5;
                this.sendRequestInitial();
            }
        }
    }

    private static /* synthetic */ Throwable lambda$awaitResponse$3(long timeout) {
        return new TimeoutException("No invocation response received in " + timeout + " milliseconds");
    }

    private static /* synthetic */ Throwable lambda$getResult$2(Throwable t) {
        return t;
    }

    private static /* synthetic */ Throwable lambda$getResult$1(Throwable t) {
        return t;
    }

    static final class ThrowableResult
    implements EJBReceiverInvocationContext.ResultProducer {
        private final Supplier<? extends Throwable> pendingFailure;

        ThrowableResult(Supplier<? extends Throwable> pendingFailure) {
            this.pendingFailure = pendingFailure;
        }

        @Override
        public Object getResult() throws Exception {
            try {
                throw this.pendingFailure.get();
            }
            catch (Error | Exception e) {
                throw e;
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }

        @Override
        public void discardResult() {
        }
    }

    final class FutureResponse
    implements Future<Object> {
        FutureResponse() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean result;
            Object lock = EJBClientInvocationContext.this.lock;
            assert (!Thread.holdsLock(lock));
            Object object = lock;
            synchronized (object) {
                if (EJBClientInvocationContext.this.state == State.DONE) {
                    return EJBClientInvocationContext.this.pendingFailure == CANCELLED_PRODUCER;
                }
                if (!EJBClientInvocationContext.this.state.isWaiting()) {
                    return EJBClientInvocationContext.this.resultProducer == CANCELLED;
                }
                if (EJBClientInvocationContext.this.resultProducer == CANCELLED) {
                    return true;
                }
                EJBClientInvocationContext.this.cancelRequested = true;
            }
            EJBReceiver receiver = EJBClientInvocationContext.this.getReceiver();
            boolean bl = result = receiver != null && receiver.cancelInvocation(EJBClientInvocationContext.this.receiverInvocationContext, mayInterruptIfRunning);
            if (!result) {
                Object object2 = lock;
                synchronized (object2) {
                    if (EJBClientInvocationContext.this.resultProducer == CANCELLED || EJBClientInvocationContext.this.state == State.DONE && EJBClientInvocationContext.this.pendingFailure == CANCELLED_PRODUCER) {
                        return true;
                    }
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCancelled() {
            Object lock = EJBClientInvocationContext.this.lock;
            assert (!Thread.holdsLock(lock));
            Object object = lock;
            synchronized (object) {
                return EJBClientInvocationContext.this.state == State.DONE ? EJBClientInvocationContext.this.pendingFailure == CANCELLED_PRODUCER : EJBClientInvocationContext.this.resultProducer == CANCELLED;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDone() {
            Object lock = EJBClientInvocationContext.this.lock;
            assert (!Thread.holdsLock(lock));
            Object object = lock;
            synchronized (object) {
                if (EJBClientInvocationContext.this.state == State.CONSUMING) {
                    return EJBClientInvocationContext.this.retryRequested && EJBClientInvocationContext.this.remainingRetries > 0 && EJBClientInvocationContext.this.resultProducer instanceof ThrowableResult;
                }
                return !EJBClientInvocationContext.this.state.isWaiting();
            }
        }

        @Override
        public Object get() throws InterruptedException, ExecutionException {
            try {
                return EJBClientInvocationContext.this.awaitResponse();
            }
            catch (InterruptedException | ExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw log.remoteInvFailed(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long ourStart;
            Object lock = EJBClientInvocationContext.this.lock;
            assert (!Thread.holdsLock(lock));
            long handlerInvTimeout = EJBClientInvocationContext.this.invocationHandler.getInvocationTimeout();
            long invocationTimeout = handlerInvTimeout != -1L ? handlerInvTimeout : EJBClientInvocationContext.this.getClientContext().getInvocationTimeout();
            if (unit.convert(Math.max(0L, invocationTimeout * 1000000L - Math.max(0L, (ourStart = System.nanoTime()) - EJBClientInvocationContext.this.startTime)), TimeUnit.NANOSECONDS) <= timeout) {
                return this.get();
            }
            long remaining = unit.toNanos(timeout);
            Object object = lock;
            synchronized (object) {
                block11: while (true) {
                    switch (EJBClientInvocationContext.this.state) {
                        case SENDING: 
                        case SENT: 
                        case WAITING: 
                        case CONSUMING: {
                            EJBClientInvocationContext.this.checkStateInvariants();
                            if (remaining <= 0L) {
                                throw log.timedOut();
                            }
                            lock.wait(remaining / 1000000000L, (int)(remaining % 1000000000L));
                            remaining = unit.toNanos(timeout) - (System.nanoTime() - ourStart);
                            continue block11;
                        }
                        case READY: {
                            EJBClientInvocationContext.this.checkStateInvariants();
                            break block11;
                        }
                        case DONE: {
                            EJBClientInvocationContext.this.checkStateInvariants();
                            if (EJBClientInvocationContext.this.pendingFailure != null) {
                                throw log.remoteInvFailed((Throwable)EJBClientInvocationContext.this.pendingFailure.get());
                            }
                            return EJBClientInvocationContext.this.cachedResult;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    break;
                }
            }
            try {
                return EJBClientInvocationContext.this.getResult();
            }
            catch (InterruptedException | ExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw log.remoteInvFailed(e);
            }
        }
    }

    static enum State {
        SENDING(true),
        SENT(true),
        WAITING(true),
        READY(false),
        CONSUMING(false),
        DONE(false);

        private final boolean waiting;

        private State(boolean waiting) {
            this.waiting = waiting;
        }

        boolean isWaiting() {
            return this.waiting;
        }
    }
}

