/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.EJBTransportProvider;
import org.jboss.ejb.protocol.remote.RemoteEJBReceiver;

public final class RemoteTransportProvider
implements EJBTransportProvider {
    static final AttachmentKey<RemoteEJBReceiver> ATTACHMENT_KEY = new AttachmentKey();
    private static final Logs log = Logs.MAIN;

    @Override
    public void notifyRegistered(EJBReceiverContext receiverContext) {
        EJBClientContext clientContext = receiverContext.getClientContext();
        RemoteEJBReceiver receiver = new RemoteEJBReceiver(this, receiverContext);
        clientContext.putAttachmentIfAbsent(ATTACHMENT_KEY, receiver);
        log.tracef("RemoteTransportProvider %s registered receiver %s with client context %s", this, receiver, clientContext);
    }

    @Override
    public boolean supportsProtocol(String uriScheme) {
        switch (uriScheme) {
            case "remote": 
            case "remote+http": 
            case "remote+https": 
            case "remoting": 
            case "http-remoting": 
            case "https-remoting": {
                return true;
            }
        }
        return false;
    }

    @Override
    public EJBReceiver getReceiver(EJBReceiverContext receiverContext, String uriScheme) throws IllegalArgumentException {
        switch (uriScheme) {
            case "remote": 
            case "remote+http": 
            case "remote+https": 
            case "remoting": 
            case "http-remoting": 
            case "https-remoting": {
                RemoteEJBReceiver receiver = receiverContext.getClientContext().getAttachment(ATTACHMENT_KEY);
                if (receiver == null) break;
                return receiver;
            }
        }
        throw new IllegalArgumentException("Unsupported EJB receiver protocol " + uriScheme);
    }
}

