/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.ejb.NoSuchEJBException;
import org.jboss.ejb._private.Keys;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.AbstractInvocationContext;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.DiscoveryEJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBSessionCreationInvocationContext;
import org.jboss.ejb.client.RequestSendFailedException;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.TransactionInterceptor;
import org.jboss.ejb.client.annotation.ClientInterceptorPriority;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.naming.client.ProviderEnvironment;

@ClientInterceptorPriority(value=200050)
public final class NamingEJBClientInterceptor
implements EJBClientInterceptor {
    public static final int PRIORITY = 200050;
    private static final AttachmentKey<Boolean> SKIP_MISSING_TARGET = new AttachmentKey();

    @Override
    public void handleInvocation(EJBClientInvocationContext context) throws Exception {
        NamingProvider namingProvider = context.getProxyAttachment(Keys.NAMING_PROVIDER_ATTACHMENT_KEY);
        if (namingProvider != null) {
            context.putAttachment(Keys.NAMING_PROVIDER_ATTACHMENT_KEY, namingProvider);
        }
        if (namingProvider == null || context.getDestination() != null || context.getLocator().getAffinity() != Affinity.NONE) {
            if (Logs.INVOCATION.isDebugEnabled()) {
                Logs.INVOCATION.debugf("NamingEJBClientInterceptor: calling handleInvocation: skipping missing target", new Object[0]);
            }
            context.putAttachment(SKIP_MISSING_TARGET, Boolean.TRUE);
            context.sendRequest();
        } else {
            if (Logs.INVOCATION.isDebugEnabled()) {
                Logs.INVOCATION.debugf("NamingEJBClientInterceptor: calling handleInvocation: setting destination", new Object[0]);
            }
            if (NamingEJBClientInterceptor.setDestination(context, namingProvider)) {
                try {
                    context.sendRequest();
                }
                catch (NoSuchEJBException | RequestSendFailedException e) {
                    this.processMissingTarget(context, (Exception)e);
                    throw e;
                }
            } else {
                throw Logs.INVOCATION.noMoreDestinations();
            }
        }
    }

    @Override
    public Object handleInvocationResult(EJBClientInvocationContext context) throws Exception {
        try {
            Object object = context.getResult();
            return object;
        }
        catch (NoSuchEJBException | RequestSendFailedException e) {
            if (context.getAttachment(SKIP_MISSING_TARGET) != Boolean.TRUE) {
                this.processMissingTarget(context, (Exception)e);
            }
            throw e;
        }
        finally {
            context.removeAttachment(SKIP_MISSING_TARGET);
        }
    }

    @Override
    public SessionID handleSessionCreation(EJBSessionCreationInvocationContext context) throws Exception {
        NamingProvider namingProvider = context.getAttachment(Keys.NAMING_PROVIDER_ATTACHMENT_KEY);
        if (namingProvider == null || context.getDestination() != null || context.getLocator().getAffinity() != Affinity.NONE) {
            return context.proceed();
        }
        if (NamingEJBClientInterceptor.setDestination(context, namingProvider)) {
            try {
                if (Logs.INVOCATION.isDebugEnabled()) {
                    Logs.INVOCATION.debugf("NamingEJBClientInterceptor: called setNamingDestination: destination = %s", context.getDestination());
                }
                SessionID theSessionID = context.proceed();
                if (Logs.INVOCATION.isDebugEnabled()) {
                    Logs.INVOCATION.debugf("NamingEJBClientInterceptor: returned from handleSessionCreation: sessionID = %s", theSessionID);
                }
                if (context instanceof EJBSessionCreationInvocationContext) {
                    DiscoveryEJBClientInterceptor.setupSessionAffinities(context);
                    if (Logs.INVOCATION.isDebugEnabled()) {
                        Logs.INVOCATION.debugf("NamingEJBClientInterceptor: called DiscoveryEJBClientInterceptor.setupSessionAffinities", new Object[0]);
                    }
                }
                return theSessionID;
            }
            catch (NoSuchEJBException | RequestSendFailedException e) {
                this.processMissingTarget(context, (Exception)e);
                throw e;
            }
        }
        throw Logs.INVOCATION.noMoreDestinations();
    }

    private static boolean setDestination(AbstractInvocationContext context, NamingProvider namingProvider) {
        Affinity weakAffinity;
        EJBLocator<?> locator;
        URI destination;
        if (namingProvider != null && (destination = context.getDestination()) == null && (locator = context.getLocator()).getAffinity() == Affinity.NONE && (weakAffinity = context.getWeakAffinity()) == Affinity.NONE) {
            return NamingEJBClientInterceptor.setNamingDestination(context, namingProvider);
        }
        return true;
    }

    static boolean setNamingDestination(AbstractInvocationContext context, NamingProvider namingProvider) {
        int size;
        List<URI> uris;
        ProviderEnvironment providerEnvironment = namingProvider.getProviderEnvironment();
        List providerUris = providerEnvironment.getProviderUris();
        if (Logs.INVOCATION.isDebugEnabled()) {
            Logs.INVOCATION.debugf("NamingEJBClientInterceptor: calling setNamingDestination: providerURIs = %s, invocationContext type = %s", providerUris.toString(), context.getClass().getName());
        }
        if ((uris = NamingEJBClientInterceptor.findPreferredURIs(context, providerUris)) == null) {
            uris = new ArrayList<URI>(providerUris.size());
            for (URI uri : providerUris) {
                if (DiscoveryEJBClientInterceptor.isBlocklisted(context, uri)) continue;
                uris.add(uri);
            }
        }
        if ((size = uris.size()) == 0) {
            return false;
        }
        if (size == 1) {
            context.setDestination(uris.get(0));
            if (Logs.INVOCATION.isDebugEnabled()) {
                Logs.INVOCATION.debugf("NamingEJBClientInterceptor: setting destination: (size == 1), destination = %s", context.getDestination());
            }
            return true;
        }
        context.setDestination(uris.get(ThreadLocalRandom.current().nextInt(size)));
        if (Logs.INVOCATION.isDebugEnabled()) {
            Logs.INVOCATION.debugf("NamingEJBClientInterceptor: setting destination: (size > 1), destination = %s", context.getDestination());
        }
        if (context instanceof EJBSessionCreationInvocationContext) {
            DiscoveryEJBClientInterceptor.setupSessionAffinities((EJBSessionCreationInvocationContext)context);
        }
        return true;
    }

    private static List<URI> findPreferredURIs(AbstractInvocationContext context, List<URI> uris) {
        Collection<URI> attachment = context.getAttachment(TransactionInterceptor.PREFERRED_DESTINATIONS);
        if (attachment == null) {
            return null;
        }
        HashSet<URI> preferred = new HashSet<URI>(attachment);
        ArrayList<URI> result = null;
        for (URI check : uris) {
            if (!preferred.contains(check) || DiscoveryEJBClientInterceptor.isBlocklisted(context, check)) continue;
            if (result == null) {
                result = new ArrayList<URI>(preferred.size());
            }
            result.add(check);
        }
        if (Logs.INVOCATION.isDebugEnabled()) {
            Logs.INVOCATION.debugf("NamingEJBClientInterceptor: computing preferred URIs: URIs = %s, preferred URIs = %s", uris, result);
        }
        return result;
    }

    private void processMissingTarget(AbstractInvocationContext context, Exception cause) {
        URI destination = context.getDestination();
        if (destination == null || context.getTargetAffinity() == Affinity.LOCAL) {
            return;
        }
        if (Logs.INVOCATION.isDebugEnabled()) {
            Logs.INVOCATION.debugf("NamingEJBClientInterceptor: missing target, *** retrying ***: locator = %s", context.getLocator());
        }
        if (DiscoveryEJBClientInterceptor.shouldBlocklist(cause)) {
            DiscoveryEJBClientInterceptor.addBlocklistedDestination(destination);
        } else {
            DiscoveryEJBClientInterceptor.addInvocationBlocklistedDestination(context, destination);
        }
        EJBLocator<?> locator = context.getLocator();
        if (!(locator.getAffinity() instanceof ClusterAffinity)) {
            context.setLocator(locator.withNewAffinity(Affinity.NONE));
            if (Logs.INVOCATION.isDebugEnabled()) {
                Logs.INVOCATION.debugf("NamingEJBClientInterceptor: resetting strong affinity = %s", context.getLocator().getAffinity());
            }
        }
        context.setWeakAffinity(Affinity.NONE);
        context.setTargetAffinity(null);
        context.setDestination(null);
        context.requestRetry();
    }
}

