/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.CtPrimitiveType;
import javassist.NotFoundException;
import org.jboss.reflect.plugins.AnnotationAttributeImpl;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.AnnotationValueFactory;
import org.jboss.reflect.plugins.AnnotationValueImpl;
import org.jboss.reflect.plugins.EnumConstantInfoImpl;
import org.jboss.reflect.plugins.javassist.JavassistAnnotationInfo;
import org.jboss.reflect.plugins.javassist.JavassistArrayInfoImpl;
import org.jboss.reflect.plugins.javassist.JavassistEnumInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfo;
import org.jboss.reflect.spi.AnnotationInfo;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.NumberInfo;
import org.jboss.reflect.spi.PrimitiveInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.NotImplementedException;
import org.jboss.util.collection.WeakClassCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistTypeInfoFactoryImpl
extends WeakClassCache
implements TypeInfoFactory,
AnnotationHelper {
    static final ClassPool pool = ClassPool.getDefault();
    static final AnnotationValue[] NO_ANNOTATIONS = new AnnotationValue[0];

    public static NoClassDefFoundError raiseClassNotFound(String name, NotFoundException e) throws NoClassDefFoundError {
        NoClassDefFoundError ex = new NoClassDefFoundError("Unable to find class");
        if (e.getCause() != null) {
            ex.initCause(e.getCause());
        }
        throw ex;
    }

    public static NoClassDefFoundError raiseClassNotFound(String name, ClassNotFoundException e) throws NoClassDefFoundError {
        NoClassDefFoundError ex = new NoClassDefFoundError("Unable to find class");
        ex.initCause(e);
        throw ex;
    }

    public static NoClassDefFoundError raiseMethodNotFound(String name, NotFoundException e) throws NoClassDefFoundError {
        NoSuchMethodError ex = new NoSuchMethodError("Unable to find method " + name);
        if (e.getCause() != null) {
            ex.initCause(e.getCause());
        }
        throw ex;
    }

    public static NoClassDefFoundError raiseFieldNotFound(String name, NotFoundException e) throws NoClassDefFoundError {
        NoSuchFieldError ex = new NoSuchFieldError("Unable to find field");
        if (e.getCause() != null) {
            ex.initCause(e.getCause());
        }
        throw ex;
    }

    protected Object instantiate(Class clazz) {
        try {
            CtClass ctClass = this.getCtClass(clazz.getName());
            if (clazz.isArray()) {
                TypeInfo componentType = this.getTypeInfo(clazz.getComponentType());
                return new JavassistArrayInfoImpl(this, ctClass, clazz, componentType);
            }
            if (ctClass.isAnnotation()) {
                JavassistAnnotationInfo result = new JavassistAnnotationInfo(this, ctClass, clazz);
                CtMethod[] methods = ctClass.getDeclaredMethods();
                AnnotationAttributeImpl[] atttributes = new AnnotationAttributeImpl[methods.length];
                for (int i = 0; i < methods.length; ++i) {
                    atttributes[i] = new AnnotationAttributeImpl(methods[i].getName(), this.getTypeInfo(methods[i].getReturnType()), null);
                }
                result.setAttributes(atttributes);
                return result;
            }
            if (ctClass.isEnum()) {
                JavassistEnumInfo enumInfo = new JavassistEnumInfo(this, ctClass, clazz);
                CtField[] fields = ctClass.getFields();
                EnumConstantInfoImpl[] constants = new EnumConstantInfoImpl[fields.length];
                int i = 0;
                for (CtField field : fields) {
                    AnnotationValue[] annotations = this.getAnnotations(field);
                    constants[i++] = new EnumConstantInfoImpl(field.getName(), enumInfo, annotations);
                }
                enumInfo.setEnumConstants(constants);
                return enumInfo;
            }
            return new JavassistTypeInfo(this, ctClass, clazz);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected TypeInfo getTypeInfo(CtClass ctClass) {
        try {
            String name = this.convertName(ctClass);
            return this.getTypeInfo(name, null);
        }
        catch (ClassNotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound(ctClass.getName(), e);
        }
    }

    protected String convertName(CtClass clazz) {
        CtClass temp = clazz;
        if (temp.isArray()) {
            JBossStringBuilder buffer = new JBossStringBuilder();
            try {
                while (temp.isArray()) {
                    buffer.append('[');
                    temp = temp.getComponentType();
                }
                if (temp.isPrimitive()) {
                    CtPrimitiveType primitive = (CtPrimitiveType)temp;
                    buffer.append(Character.toString(primitive.getDescriptor()));
                } else {
                    buffer.append('L');
                    buffer.append(temp.getName());
                    buffer.append(';');
                }
                return buffer.toString();
            }
            catch (NotFoundException e) {
                throw JavassistTypeInfoFactoryImpl.raiseClassNotFound(clazz.getName(), e);
            }
        }
        return clazz.getName();
    }

    protected CtClass getCtClass(String name) {
        try {
            return pool.get(name);
        }
        catch (NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound(name, e);
        }
    }

    protected void generate(Class clazz, Object result) {
    }

    @Override
    public TypeInfo getTypeInfo(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        PrimitiveInfo primitive = PrimitiveInfo.valueOf(clazz.getName());
        if (primitive != null) {
            return primitive;
        }
        NumberInfo number = NumberInfo.valueOf(clazz.getName());
        if (number != null) {
            if (!number.isInitialized()) {
                number.setDelegate((TypeInfo)this.get(clazz));
            }
            return number;
        }
        return (TypeInfo)this.get(clazz);
    }

    @Override
    public TypeInfo getTypeInfo(String name, ClassLoader cl) throws ClassNotFoundException {
        PrimitiveInfo primitive;
        if (name == null) {
            throw new IllegalArgumentException("Null class name");
        }
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if ((primitive = PrimitiveInfo.valueOf(name)) != null) {
            return primitive;
        }
        NumberInfo number = NumberInfo.valueOf(name);
        if (number != null) {
            if (!number.isInitialized()) {
                number.setDelegate((TypeInfo)this.get(Class.forName(name, false, cl)));
            }
            return number;
        }
        Class<?> clazz = Class.forName(name, false, cl);
        return this.getTypeInfo(clazz);
    }

    @Override
    public TypeInfo getTypeInfo(Type type) {
        if (type instanceof Class) {
            return this.getTypeInfo((Class)type);
        }
        throw new NotImplementedException("getTypeInfo");
    }

    @Override
    public AnnotationValue[] getAnnotations(Object obj) {
        try {
            Object[] annotations;
            if (obj instanceof CtMember) {
                annotations = ((CtMember)obj).getAvailableAnnotations();
            } else if (obj instanceof CtClass) {
                annotations = ((CtClass)obj).getAvailableAnnotations();
            } else {
                throw new RuntimeException("Attempt was made to read annotations from unsupported type " + obj.getClass().getName() + ": " + obj);
            }
            if (annotations.length == 0) {
                return NO_ANNOTATIONS;
            }
            AnnotationValue[] annotationValues = new AnnotationValueImpl[annotations.length];
            for (int i = 0; i < annotations.length; ++i) {
                Class<? extends Annotation> clazz = ((Annotation)annotations[i]).annotationType();
                AnnotationInfo info = (AnnotationInfo)this.getTypeInfo(clazz);
                annotationValues[i] = AnnotationValueFactory.createAnnotationValue(this, this, info, annotations[i]);
            }
            return annotationValues;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public AnnotationValue createAnnotationValue(AnnotationInfo info, Object ann) {
        return AnnotationValueFactory.createAnnotationValue(this, this, info, ann);
    }
}

