/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.bytecode.SignatureAttribute;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.javassist.AbstractJavassistBody;
import org.jboss.reflect.plugins.javassist.JavassistAnnotatedInfo;
import org.jboss.reflect.plugins.javassist.JavassistHelper;
import org.jboss.reflect.plugins.javassist.JavassistParameterInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactoryImpl;
import org.jboss.reflect.plugins.javassist.JavassistUtil;
import org.jboss.reflect.spi.AnnotationInfo;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.Body;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ModifierInfo;
import org.jboss.reflect.spi.NotFoundException;
import org.jboss.reflect.spi.ParameterInfo;
import org.jboss.reflect.spi.TypeInfo;

public abstract class JavassistAnnotatedParameterInfo
extends JavassistAnnotatedInfo {
    private static final long serialVersionUID = -494071110672611729L;
    protected volatile transient ParameterInfo[] parameters;
    protected volatile transient TypeInfo[] parameterTypes;
    protected volatile transient ClassInfo[] exceptionTypes;
    protected final JavassistTypeInfo typeInfo;
    protected final CtBehavior ctBehavior;

    public JavassistAnnotatedParameterInfo(AnnotationHelper annotationHelper, JavassistTypeInfo typeInfo, CtBehavior ctBehavior) {
        super(annotationHelper);
        this.typeInfo = typeInfo;
        this.ctBehavior = ctBehavior;
    }

    public int getModifiers() {
        return this.ctBehavior.getModifiers();
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.ctBehavior.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.ctBehavior.getModifiers());
    }

    public boolean isVolatile() {
        return Modifier.isVolatile(this.ctBehavior.getModifiers());
    }

    public ClassInfo getDeclaringClass() {
        return this.typeInfo;
    }

    public ClassInfo[] getExceptionTypes() {
        if (this.exceptionTypes == null) {
            try {
                CtClass[] types = this.ctBehavior.getExceptionTypes();
                ClassInfo[] exceptionTypes = new ClassInfo[types.length];
                for (int i = 0; i < types.length; ++i) {
                    exceptionTypes[i] = (ClassInfo)this.typeInfo.getFactory().getTypeInfo(types[i]);
                }
                this.exceptionTypes = exceptionTypes;
            }
            catch (javassist.NotFoundException e) {
                throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for exception types of constructor", e);
            }
        }
        return this.exceptionTypes;
    }

    protected synchronized void generateParameters() {
        if (this.parameters != null) {
            return;
        }
        try {
            SignatureAttribute.MethodSignature sig = JavassistHelper.getMethodSignature(this.ctBehavior);
            if (sig != null && sig.getParameterTypes().length == this.ctBehavior.getParameterTypes().length) {
                this.parameterTypes = JavassistHelper.createParameterTypes(this.ctBehavior, sig, this.typeInfo);
            } else {
                CtClass[] types = this.ctBehavior.getParameterTypes();
                this.parameterTypes = new TypeInfo[types.length];
                for (int i = 0; i < types.length; ++i) {
                    this.parameterTypes[i] = this.typeInfo.getFactory().getTypeInfo(types[i]);
                }
            }
            this.parameters = new ParameterInfo[this.parameterTypes.length];
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                this.parameters[i] = new JavassistParameterInfo(this.annotationHelper, this, i, this.parameterTypes[i]);
            }
        }
        catch (javassist.NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for parameters of constructor", e);
        }
    }

    public ParameterInfo[] getParameters() {
        if (this.parameters == null) {
            this.generateParameters();
        }
        return this.parameters;
    }

    public TypeInfo[] getParameterTypes() {
        if (this.parameterTypes == null) {
            this.generateParameters();
        }
        return this.parameterTypes;
    }

    public AnnotationValue[] getAnnotations() {
        return this.getAnnotations(this.ctBehavior);
    }

    protected void setupParameterAnnotations(Object[][] annotations) {
        for (int param = 0; param < annotations.length; ++param) {
            AnnotationValue[] annotationValues = new AnnotationValue[annotations[param].length];
            for (int ann = 0; ann < annotationValues.length; ++ann) {
                Class<? extends Annotation> clazz = ((Annotation)annotations[param][ann]).annotationType();
                AnnotationInfo info = (AnnotationInfo)((JavassistTypeInfoFactoryImpl)this.annotationHelper).getTypeInfo(clazz);
                annotationValues[ann] = this.annotationHelper.createAnnotationValue(info, annotations[param][ann]);
            }
            ((JavassistParameterInfo)this.parameters[param]).setAnnotations(annotationValues);
        }
    }

    protected void createParameterAnnotations() {
        try {
            Object[][] parameterAnnotations = this.ctBehavior.getParameterAnnotations();
            this.setupParameterAnnotations(parameterAnnotations);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void setBody(Body body) {
        this.typeInfo.clearMethodCache();
        if (!(body instanceof AbstractJavassistBody)) {
            throw new IllegalArgumentException("Body is not an instance of AbstractJavassistBody");
        }
        ((AbstractJavassistBody)body).createBody(this.ctBehavior);
    }

    public void setExceptions(String[] exceptions) {
        this.typeInfo.clearMethodCache();
        try {
            this.ctBehavior.setExceptionTypes(JavassistUtil.toCtClass(this.typeInfo.getCtClass().getClassPool(), exceptions));
        }
        catch (javassist.NotFoundException e) {
            throw new NotFoundException(e.toString());
        }
    }

    public void setExceptions(ClassInfo[] exceptions) {
        try {
            this.ctBehavior.setExceptionTypes(JavassistUtil.toCtClass(exceptions));
        }
        catch (javassist.NotFoundException e) {
            throw new NotFoundException(e.toString());
        }
        this.typeInfo.clearMethodCache();
    }

    public void setModifier(ModifierInfo mi) {
        this.ctBehavior.setModifiers(mi.getModifiers());
        this.typeInfo.clearMethodCache();
    }

    public void setParameters(String[] parameters) {
        for (String p : parameters) {
            try {
                this.ctBehavior.addParameter(JavassistUtil.toCtClass(this.typeInfo.getCtClass().getClassPool(), p));
            }
            catch (CannotCompileException e) {
                throw new org.jboss.reflect.spi.CannotCompileException(e.toString());
            }
        }
        this.typeInfo.clearMethodCache();
    }

    public void setParameters(ClassInfo[] parameters) {
        for (ClassInfo clazz : parameters) {
            try {
                this.ctBehavior.addParameter(JavassistUtil.toCtClass(clazz));
            }
            catch (CannotCompileException e) {
                throw new org.jboss.reflect.spi.CannotCompileException(e.toString());
            }
        }
        this.typeInfo.clearMethodCache();
    }
}

