/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming.remote.protocol.v1;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.management.RuntimeMBeanException;
import org.jboss.logging.Logger;
import org.jboss.naming.remote.protocol.ProtocolCommand;
import org.jboss.naming.remote.protocol.v1.Protocol;
import org.jboss.naming.remote.protocol.v1.WriteUtil;
import org.jboss.naming.remote.server.RemoteNamingServer;
import org.jboss.naming.remote.server.RemoteNamingServerLogger;
import org.jboss.naming.remote.server.RemoteNamingService;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;
import org.xnio.IoUtils;

public class RemoteNamingServerV1
implements RemoteNamingServer {
    private static final Logger log = Logger.getLogger(RemoteNamingServerV1.class);
    private final Channel channel;
    private final RemoteNamingService remoteNamingService;
    private final RemoteNamingServerLogger logger;

    public RemoteNamingServerV1(Channel channel, RemoteNamingService remoteNamingServer) {
        this.channel = channel;
        this.remoteNamingService = remoteNamingServer;
        this.logger = remoteNamingServer.getLogger();
    }

    @Override
    public void start() {
        this.channel.receiveMessage((Channel.Receiver)new MessageReciever());
    }

    private class MessageReciever
    implements Channel.Receiver {
        private MessageReciever() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(final Channel channel, MessageInputStream message) {
            block6: {
                final DataInputStream dis = new DataInputStream((InputStream)message);
                try {
                    final byte messageId = dis.readByte();
                    final int correlationId = dis.readInt();
                    log.tracef("Message Received id(%h), correlationId(%d)", (Object)messageId, (Object)correlationId);
                    final ProtocolCommand command = Protocol.forId(messageId);
                    if (command != null) {
                        RemoteNamingServerV1.this.remoteNamingService.getExecutor().execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    command.handleServerMessage(channel, dis, correlationId, RemoteNamingServerV1.this.remoteNamingService);
                                }
                                catch (Throwable t) {
                                    if (correlationId != 0) {
                                        Exception response;
                                        if (t instanceof IOException) {
                                            response = (Exception)t;
                                        } else if (t instanceof RuntimeMBeanException) {
                                            response = (Exception)t;
                                        } else {
                                            response = new IOException("Internal server error.");
                                            RemoteNamingServerV1.this.logger.unnexpectedError(t);
                                        }
                                        this.sendIOException(response);
                                    } else {
                                        RemoteNamingServerV1.this.logger.nullCorrelationId(t);
                                    }
                                }
                                finally {
                                    IoUtils.safeClose((Closeable)dis);
                                }
                            }

                            private void sendIOException(Exception e) {
                                try {
                                    WriteUtil.writeExceptionResponse(channel, e, messageId, correlationId);
                                    log.tracef("[%d] %h - Success Response Sent", (Object)correlationId, (Object)messageId);
                                }
                                catch (IOException ioe) {
                                    RemoteNamingServerV1.this.logger.failedToSendExceptionResponse(ioe);
                                }
                            }
                        });
                        break block6;
                    }
                    throw new IOException("Unrecognised Message ID");
                }
                catch (Throwable e) {
                    RemoteNamingServerV1.this.logger.unnexpectedError(e);
                    IoUtils.safeClose((Closeable)dis);
                }
                finally {
                    channel.receiveMessage((Channel.Receiver)this);
                }
            }
        }

        public void handleError(Channel channel, IOException error) {
            RemoteNamingServerV1.this.logger.closingChannel(channel, error);
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void handleEnd(Channel channel) {
            RemoteNamingServerV1.this.logger.closingChannelOnChannelEnd(channel);
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

