/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.binders;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.atmos.binders.BindUserMetadataToHeaders;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindMetadataToHeaders
implements Binder {
    private final BindUserMetadataToHeaders metaBinder;

    @Inject
    protected BindMetadataToHeaders(BindUserMetadataToHeaders metaBinder) {
        this.metaBinder = metaBinder;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof AtmosObject), (Object)"this binder is only valid for AtmosObject!");
        Preconditions.checkNotNull(request, (Object)"request");
        AtmosObject object = (AtmosObject)AtmosObject.class.cast(input);
        Preconditions.checkNotNull((Object)object.getPayload(), (Object)"object payload");
        Preconditions.checkArgument((object.getPayload().getContentMetadata().getContentLength() != null ? 1 : 0) != 0, (Object)"contentLength must be set, streaming not supported");
        return this.metaBinder.bindToRequest(request, object.getUserMetadata());
    }
}

