/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudfiles.config;

import com.google.common.base.Supplier;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.net.URI;
import javax.inject.Singleton;
import org.jclouds.cloudfiles.CDNManagement;
import org.jclouds.cloudfiles.CloudFilesAsyncClient;
import org.jclouds.cloudfiles.CloudFilesClient;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.RequiresHttp;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.json.config.GsonModule;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.openstack.keystone.v1_1.config.AuthenticationServiceModule;
import org.jclouds.openstack.swift.CommonSwiftAsyncClient;
import org.jclouds.openstack.swift.CommonSwiftClient;
import org.jclouds.openstack.swift.Storage;
import org.jclouds.openstack.swift.config.SwiftObjectModule;
import org.jclouds.openstack.swift.handlers.ParseSwiftErrorFromHttpResponse;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.config.RestClientModule;
import org.jclouds.util.Suppliers2;

@ConfiguresRestClient
@RequiresHttp
public class CloudFilesRestClientModule
extends RestClientModule<CloudFilesClient, CloudFilesAsyncClient> {
    public CloudFilesRestClientModule() {
        super(CloudFilesClient.class, CloudFilesAsyncClient.class);
    }

    @Provides
    @Singleton
    CommonSwiftClient provideCommonSwiftClient(CloudFilesClient in) {
        return in;
    }

    @Provides
    @Singleton
    CommonSwiftAsyncClient provideCommonSwiftClient(CloudFilesAsyncClient in) {
        return in;
    }

    protected void configure() {
        this.install((Module)new SwiftObjectModule());
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        super.configure();
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseSwiftErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseSwiftErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseSwiftErrorFromHttpResponse.class);
    }

    protected void installLocations() {
        super.installLocations();
        this.install((Module)new AuthenticationServiceModule());
    }

    @Provides
    @Singleton
    @CDNManagement
    protected Supplier<URI> provideCDNUrl(RegionIdToURISupplier.Factory factory, @ApiVersion String apiVersion) {
        return Suppliers2.getLastValueInMap((Supplier)factory.createForApiTypeAndVersion("cloudFilesCDN", apiVersion));
    }

    @Provides
    @Singleton
    @Storage
    protected Supplier<URI> provideStorageUrl(RegionIdToURISupplier.Factory factory, @ApiVersion String apiVersion) {
        return Suppliers2.getLastValueInMap((Supplier)factory.createForApiTypeAndVersion("cloudFiles", apiVersion));
    }
}

