/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudfiles.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.net.URI;
import org.jclouds.cloudfiles.domain.ContainerCDNMetadata;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.InvocationContext;

public class ParseContainerCDNMetadataFromHeaders
implements Function<HttpResponse, ContainerCDNMetadata>,
InvocationContext<ParseContainerCDNMetadataFromHeaders> {
    private HttpRequest request;

    public ContainerCDNMetadata apply(HttpResponse from) {
        String cdnUri = (String)Preconditions.checkNotNull((Object)from.getFirstHeaderOrNull("X-CDN-URI"), (Object)"X-CDN-URI");
        String cdnTTL = (String)Preconditions.checkNotNull((Object)from.getFirstHeaderOrNull("X-TTL"), (Object)"X-TTL");
        String cdnEnabled = (String)Preconditions.checkNotNull((Object)from.getFirstHeaderOrNull("X-CDN-Enabled"), (Object)"X-CDN-Enabled");
        if (cdnUri == null) {
            return null;
        }
        return new ContainerCDNMetadata(this.request.getEndpoint().getPath(), Boolean.parseBoolean(cdnEnabled), Long.parseLong(cdnTTL), URI.create(cdnUri));
    }

    public ParseContainerCDNMetadataFromHeaders setContext(HttpRequest request) {
        this.request = request;
        return this;
    }
}

