/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudloadbalancers.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.SortedSet;
import org.jclouds.cloudloadbalancers.domain.internal.BaseNode;
import org.jclouds.javax.annotation.Nullable;

public class BaseLoadBalancer<N extends BaseNode<N>, T extends BaseLoadBalancer<N, T>>
implements Comparable<BaseLoadBalancer<N, T>> {
    protected String name;
    protected String protocol;
    protected Integer port;
    protected String algorithm;
    protected SortedSet<N> nodes = ImmutableSortedSet.of();

    public static <N extends BaseNode<N>, T extends BaseLoadBalancer<N, T>> Builder<N, T> builder() {
        return new Builder();
    }

    public Builder<N, T> toBuilder() {
        return new Builder().from(this);
    }

    protected BaseLoadBalancer() {
    }

    public BaseLoadBalancer(String name, String protocol, Integer port, @Nullable String algorithm, Iterable<N> nodes) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.protocol = protocol;
        this.port = port;
        this.algorithm = algorithm;
        this.nodes = ImmutableSortedSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(nodes, (Object)"nodes")));
    }

    @Override
    public int compareTo(BaseLoadBalancer<N, T> arg0) {
        return this.name.compareTo(arg0.name);
    }

    public String getName() {
        return this.name;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Integer getPort() {
        return this.port;
    }

    @Nullable
    public String getAlgorithm() {
        return this.algorithm;
    }

    public Set<N> getNodes() {
        return this.nodes;
    }

    public int hashCode() {
        Integer prime = 31;
        Integer result = 1;
        result = prime * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseLoadBalancer other = (BaseLoadBalancer)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return String.format("[name=%s, port=%s, protocol=%s, algorithm=%s, nodes=%s]", this.name, this.port, this.protocol, this.algorithm, this.nodes);
    }

    public static class Builder<N extends BaseNode<N>, T extends BaseLoadBalancer<N, T>> {
        protected String name;
        protected String protocol;
        protected Integer port;
        protected String algorithm;
        protected Set<N> nodes = Sets.newLinkedHashSet();

        public Builder<N, T> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<N, T> protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder<N, T> port(Integer port) {
            this.port = port;
            return this;
        }

        public Builder<N, T> algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder<N, T> nodes(Iterable<N> nodes) {
            this.nodes = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(nodes, (Object)"nodes")));
            return this;
        }

        public Builder<N, T> node(N node) {
            this.nodes.add((BaseNode)Preconditions.checkNotNull(this.nodes, (Object)"nodes"));
            return this;
        }

        public BaseLoadBalancer<N, T> build() {
            return new BaseLoadBalancer(this.name, this.protocol, this.port, this.algorithm, this.nodes);
        }

        public Builder<N, T> from(T baseLoadBalancer) {
            return this.name(((BaseLoadBalancer)baseLoadBalancer).getName()).port(((BaseLoadBalancer)baseLoadBalancer).getPort()).protocol(((BaseLoadBalancer)baseLoadBalancer).getProtocol()).algorithm(((BaseLoadBalancer)baseLoadBalancer).getAlgorithm()).nodes(((BaseLoadBalancer)baseLoadBalancer).getNodes());
        }
    }
}

