/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudloadbalancers.domain.internal;

import com.google.common.base.Preconditions;

public class BaseNode<T extends BaseNode<T>>
implements Comparable<BaseNode<T>> {
    protected String address;
    protected int port;
    protected Condition condition;
    protected Integer weight;

    public static <T extends BaseNode<T>> Builder<T> builder() {
        return new Builder();
    }

    public Builder<T> toBuilder() {
        return new Builder<BaseNode>().from(this);
    }

    protected BaseNode() {
    }

    public BaseNode(String address, int port, Condition condition, Integer weight) {
        this.address = (String)Preconditions.checkNotNull((Object)address, (Object)"address");
        Preconditions.checkArgument((port != -1 ? 1 : 0) != 0, (Object)"port must be specified");
        this.port = port;
        this.condition = (Condition)((Object)Preconditions.checkNotNull((Object)((Object)condition), (Object)"condition"));
        this.weight = weight;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public Integer getWeight() {
        return this.weight;
    }

    @Override
    public int compareTo(BaseNode<T> arg0) {
        return this.address.compareTo(arg0.address);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
        result = 31 * result + this.port;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseNode other = (BaseNode)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.condition == null ? other.condition != null : !this.condition.equals((Object)other.condition)) {
            return false;
        }
        return this.port == other.port;
    }

    public String toString() {
        return String.format("[address=%s, condition=%s, port=%s, weight=%s]", new Object[]{this.address, this.condition, this.port, this.weight});
    }

    public static enum Condition {
        ENABLED,
        DISABLED,
        DRAINING,
        UNRECOGNIZED;


        public static Condition fromValue(String condition) {
            try {
                return Condition.valueOf((String)Preconditions.checkNotNull((Object)condition, (Object)"condition"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static class Builder<T extends BaseNode<T>> {
        protected String address;
        protected int port = -1;
        protected Condition condition = Condition.ENABLED;
        protected Integer weight;

        public Builder<T> address(String address) {
            this.address = address;
            return this;
        }

        public Builder<T> port(int port) {
            this.port = port;
            return this;
        }

        public Builder<T> condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        public Builder<T> weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public BaseNode<T> build() {
            return new BaseNode(this.address, this.port, this.condition, this.weight);
        }

        public Builder<T> from(T in) {
            return this.address(((BaseNode)in).getAddress()).port(((BaseNode)in).getPort()).condition(((BaseNode)in).getCondition()).weight(((BaseNode)in).getWeight());
        }
    }
}

