/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudloadbalancers.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.cloudloadbalancers.domain.Node;
import org.jclouds.cloudloadbalancers.domain.NodeAttributes;
import org.jclouds.cloudloadbalancers.domain.NodeRequest;
import org.jclouds.openstack.filters.AuthenticateRequest;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.WrapWith;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;

@SkipEncoding(value={47})
@RequestFilters(value={AuthenticateRequest.class})
public interface NodeAsyncClient {
    @POST
    @SelectJson(value="nodes")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Path(value="/loadbalancers/{lbid}/nodes")
    public ListenableFuture<Set<Node>> createNodesInLoadBalancer(@WrapWith(value="nodes") Set<NodeRequest> var1, @PathParam(value="lbid") int var2);

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="/loadbalancers/{lbid}/nodes/{nid}")
    public ListenableFuture<Void> updateAttributesForNodeInLoadBalancer(@WrapWith(value="node") NodeAttributes var1, @PathParam(value="nid") int var2, @PathParam(value="lbid") int var3);

    @GET
    @SelectJson(value="nodes")
    @Consumes(value={"application/json"})
    @Path(value="/loadbalancers/{lbid}/nodes")
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<Node>> listNodes(@PathParam(value="lbid") int var1);

    @GET
    @SelectJson(value="node")
    @Consumes(value={"application/json"})
    @Path(value="/loadbalancers/{lbid}/nodes/{nid}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Node> getNodeInLoadBalancer(@PathParam(value="nid") int var1, @PathParam(value="lbid") int var2);

    @DELETE
    @Path(value="/loadbalancers/{lbid}/nodes/{nid}")
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    @Consumes(value={"*/*"})
    public ListenableFuture<Void> removeNodeFromLoadBalancer(@PathParam(value="nid") int var1, @PathParam(value="lbid") int var2);

    @DELETE
    @Path(value="/loadbalancers/{lbid}/nodes")
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    @Consumes(value={"*/*"})
    public ListenableFuture<Void> removeNodesFromLoadBalancer(@QueryParam(value="id") Set<Integer> var1, @PathParam(value="lbid") int var2);
}

