/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudloadbalancers.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.cloudloadbalancers.domain.LoadBalancer;
import org.jclouds.cloudloadbalancers.functions.ConvertLB;
import org.jclouds.cloudloadbalancers.functions.LB;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.rest.InvocationContext;

public class UnwrapLoadBalancer
implements Function<HttpResponse, LoadBalancer>,
InvocationContext<UnwrapLoadBalancer> {
    private final ParseJson<Map<String, LB>> json;
    private final ConvertLB.Factory factory;
    private ConvertLB convertLB;

    @Inject
    UnwrapLoadBalancer(ParseJson<Map<String, LB>> json, ConvertLB.Factory factory) {
        this.json = (ParseJson)Preconditions.checkNotNull(json, (Object)"json");
        this.factory = (ConvertLB.Factory)Preconditions.checkNotNull((Object)factory, (Object)"factory");
    }

    public LoadBalancer apply(HttpResponse arg0) {
        Preconditions.checkState((this.convertLB != null ? 1 : 0) != 0, (Object)"convertLB should be set by InvocationContext");
        Map map = (Map)this.json.apply(arg0);
        if (map == null || map.size() == 0) {
            return null;
        }
        LB lb = (LB)Iterables.get(map.values(), (int)0);
        return this.convertLB.apply(lb);
    }

    public UnwrapLoadBalancer setContext(HttpRequest request) {
        return this.setRegion(request.getEndpoint().getHost().substring(0, request.getEndpoint().getHost().indexOf(46)));
    }

    UnwrapLoadBalancer setRegion(String region) {
        this.convertLB = this.factory.createForRegion(region);
        return this;
    }
}

