/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudloadbalancers.loadbalancer.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudloadbalancers.CloudLoadBalancersAsyncClient;
import org.jclouds.cloudloadbalancers.domain.LoadBalancer;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.loadbalancer.domain.LoadBalancerMetadata;
import org.jclouds.loadbalancer.strategy.ListLoadBalancersStrategy;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;

@Singleton
public class CloudLoadBalancersListLoadBalancersStrategy
implements ListLoadBalancersStrategy {
    @Resource
    @Named(value="jclouds.loadbalancer")
    protected Logger logger = Logger.NULL;
    private final CloudLoadBalancersAsyncClient aclient;
    private final Function<LoadBalancer, LoadBalancerMetadata> converter;
    private final ExecutorService executor;
    private final Set<String> regions;

    @Inject
    protected CloudLoadBalancersListLoadBalancersStrategy(CloudLoadBalancersAsyncClient aclient, Function<LoadBalancer, LoadBalancerMetadata> converter, @Named(value="jclouds.user-threads") ExecutorService executor, @Nullable @Region Set<String> regions) {
        this.aclient = (CloudLoadBalancersAsyncClient)Preconditions.checkNotNull((Object)aclient, (Object)"aclient");
        this.regions = (Set)Preconditions.checkNotNull(regions, (Object)"regions");
        this.converter = (Function)Preconditions.checkNotNull(converter, (Object)"converter");
        this.executor = (ExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor");
    }

    public Iterable<? extends LoadBalancerMetadata> listLoadBalancers() {
        return Iterables.transform((Iterable)Iterables.concat((Iterable)FutureIterables.transformParallel(this.regions, (Function)new Function<String, Future<Set<LoadBalancer>>>(){

            public ListenableFuture<Set<LoadBalancer>> apply(String from) {
                return CloudLoadBalancersListLoadBalancersStrategy.this.aclient.getLoadBalancerClient(from).listLoadBalancers();
            }
        }, (ExecutorService)this.executor, null, (Logger)this.logger, (String)"loadbalancers")), this.converter);
    }
}

