/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudloadbalancers.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class ListOptions
extends BaseHttpRequestOptions {
    public static final ListOptions NONE = new ListOptions();

    public ListOptions marker(String marker) {
        Preconditions.checkArgument((marker != null ? 1 : 0) != 0, (Object)"marker cannot be null");
        this.queryParameters.replaceValues((Object)"marker", (Iterable)ImmutableSet.of((Object)marker));
        return this;
    }

    public ListOptions limit(int limit) {
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (Object)"limit must be >= 0");
        Preconditions.checkArgument((limit <= 10000 ? 1 : 0) != 0, (Object)"limit must be <= 10000");
        this.queryParameters.replaceValues((Object)"limit", (Iterable)ImmutableSet.of((Object)(limit + "")));
        return this;
    }

    public static class Builder {
        public static ListOptions marker(String marker) {
            ListOptions options = new ListOptions();
            return options.marker(marker);
        }

        public static ListOptions limit(int limit) {
            ListOptions options = new ListOptions();
            return options.limit(limit);
        }
    }
}

