/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudloadbalancers.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.cloudloadbalancers.CloudLoadBalancersClient;
import org.jclouds.cloudloadbalancers.domain.LoadBalancer;
import org.jclouds.logging.Logger;

@Singleton
public class LoadBalancerActive
implements Predicate<LoadBalancer> {
    private final CloudLoadBalancersClient client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public LoadBalancerActive(CloudLoadBalancersClient client) {
        this.client = client;
    }

    public boolean apply(LoadBalancer loadBalancer) {
        this.logger.trace("looking for status on loadBalancer %s", new Object[]{Preconditions.checkNotNull((Object)loadBalancer, (Object)"loadBalancer")});
        loadBalancer = this.refresh(loadBalancer);
        if (loadBalancer == null) {
            return false;
        }
        this.logger.trace("%s: looking for loadBalancer status %s: currently: %s", new Object[]{loadBalancer.getId(), LoadBalancer.Status.ACTIVE, loadBalancer.getStatus()});
        if (loadBalancer.getStatus() == LoadBalancer.Status.ERROR) {
            throw new IllegalStateException("loadBalancer in error status: " + loadBalancer);
        }
        return loadBalancer.getStatus() == LoadBalancer.Status.ACTIVE;
    }

    private LoadBalancer refresh(LoadBalancer loadBalancer) {
        return this.client.getLoadBalancerClient(loadBalancer.getRegion()).getLoadBalancer(loadBalancer.getId());
    }
}

