/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.domain;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import org.jclouds.cloudservers.domain.DailyBackup;
import org.jclouds.cloudservers.domain.WeeklyBackup;
import org.jclouds.javax.annotation.Nullable;

public class BackupSchedule {
    private final DailyBackup daily;
    private final boolean enabled;
    private final WeeklyBackup weekly;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromBackupSchedule(this);
    }

    @ConstructorProperties(value={"daily", "enabled", "weekly"})
    protected BackupSchedule(@Nullable DailyBackup daily, boolean enabled, @Nullable WeeklyBackup weekly) {
        this.daily = daily;
        this.enabled = enabled;
        this.weekly = weekly;
    }

    @Nullable
    public DailyBackup getDaily() {
        return this.daily;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nullable
    public WeeklyBackup getWeekly() {
        return this.weekly;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.daily, this.enabled, this.weekly});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BackupSchedule that = (BackupSchedule)BackupSchedule.class.cast(obj);
        return Objects.equal((Object)((Object)this.daily), (Object)((Object)that.daily)) && Objects.equal((Object)this.enabled, (Object)that.enabled) && Objects.equal((Object)((Object)this.weekly), (Object)((Object)that.weekly));
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("daily", (Object)this.daily).add("enabled", this.enabled).add("weekly", (Object)this.weekly);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected DailyBackup daily;
        protected boolean enabled;
        protected WeeklyBackup weekly;

        protected abstract T self();

        public T daily(DailyBackup daily) {
            this.daily = daily;
            return this.self();
        }

        public T enabled(boolean enabled) {
            this.enabled = enabled;
            return this.self();
        }

        public T weekly(WeeklyBackup weekly) {
            this.weekly = weekly;
            return this.self();
        }

        public BackupSchedule build() {
            return new BackupSchedule(this.daily, this.enabled, this.weekly);
        }

        public T fromBackupSchedule(BackupSchedule in) {
            return ((Builder)((Builder)this.daily(in.getDaily())).enabled(in.isEnabled())).weekly(in.getWeekly());
        }
    }
}

