/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.util.Map;
import org.jclouds.cloudservers.domain.Addresses;
import org.jclouds.cloudservers.domain.ServerStatus;
import org.jclouds.javax.annotation.Nullable;

public class Server {
    private final int id;
    private final String name;
    private final Map<String, String> metadata;
    private final Addresses addresses;
    private final String adminPass;
    private final Integer flavorId;
    private final String hostId;
    private final Integer imageId;
    private final Integer sharedIpGroupId;
    private final Integer progress;
    private final ServerStatus status;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromServer(this);
    }

    @ConstructorProperties(value={"id", "name", "metadata", "addresses", "adminPass", "flavorId", "hostId", "imageId", "sharedIpGroupId", "progress", "status"})
    protected Server(int id, String name, @Nullable Map<String, String> metadata, @Nullable Addresses addresses, @Nullable String adminPass, @Nullable Integer flavorId, @Nullable String hostId, @Nullable Integer imageId, @Nullable Integer sharedIpGroupId, @Nullable Integer progress, @Nullable ServerStatus status) {
        this.id = id;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.metadata = metadata == null ? null : ImmutableMap.copyOf(metadata);
        this.addresses = addresses;
        this.adminPass = adminPass;
        this.flavorId = flavorId;
        this.hostId = hostId;
        this.imageId = imageId;
        this.sharedIpGroupId = sharedIpGroupId;
        this.progress = progress;
        this.status = status == null ? ServerStatus.UNKNOWN : status;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Nullable
    public Addresses getAddresses() {
        return this.addresses;
    }

    @Nullable
    public String getAdminPass() {
        return this.adminPass;
    }

    @Nullable
    public Integer getFlavorId() {
        return this.flavorId;
    }

    @Nullable
    public String getHostId() {
        return this.hostId;
    }

    @Nullable
    public Integer getImageId() {
        return this.imageId;
    }

    @Nullable
    public Integer getSharedIpGroupId() {
        return this.sharedIpGroupId;
    }

    @Nullable
    public Integer getProgress() {
        return this.progress;
    }

    public ServerStatus getStatus() {
        return this.status;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.metadata, this.addresses, this.adminPass, this.flavorId, this.hostId, this.imageId, this.sharedIpGroupId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Server that = (Server)Server.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.metadata, that.metadata) && Objects.equal((Object)this.addresses, (Object)that.addresses) && Objects.equal((Object)this.adminPass, (Object)that.adminPass) && Objects.equal((Object)this.flavorId, (Object)that.flavorId) && Objects.equal((Object)this.hostId, (Object)that.hostId) && Objects.equal((Object)this.imageId, (Object)that.imageId) && Objects.equal((Object)this.sharedIpGroupId, (Object)that.sharedIpGroupId);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", this.id).add("name", (Object)this.name).add("metadata", this.metadata).add("addresses", (Object)this.addresses).add("adminPass", (Object)this.adminPass).add("flavorId", (Object)this.flavorId).add("hostId", (Object)this.hostId).add("imageId", (Object)this.imageId).add("sharedIpGroupId", (Object)this.sharedIpGroupId).add("progress", (Object)this.progress).add("status", (Object)this.status);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected int id;
        protected String name;
        protected Map<String, String> metadata;
        protected Addresses addresses;
        protected String adminPass;
        protected Integer flavorId;
        protected String hostId;
        protected Integer imageId;
        protected Integer sharedIpGroupId;
        protected Integer progress;
        protected ServerStatus status;

        protected abstract T self();

        public T id(int id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T metadata(Map<String, String> metadata) {
            this.metadata = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(metadata, (Object)"metadata")));
            return this.self();
        }

        public T addresses(Addresses addresses) {
            this.addresses = addresses;
            return this.self();
        }

        public T adminPass(String adminPass) {
            this.adminPass = adminPass;
            return this.self();
        }

        public T flavorId(Integer flavorId) {
            this.flavorId = flavorId;
            return this.self();
        }

        public T hostId(String hostId) {
            this.hostId = hostId;
            return this.self();
        }

        public T imageId(Integer imageId) {
            this.imageId = imageId;
            return this.self();
        }

        public T sharedIpGroupId(Integer sharedIpGroupId) {
            this.sharedIpGroupId = sharedIpGroupId;
            return this.self();
        }

        public T progress(Integer progress) {
            this.progress = progress;
            return this.self();
        }

        public T status(ServerStatus status) {
            this.status = status;
            return this.self();
        }

        public Server build() {
            return new Server(this.id, this.name, this.metadata, this.addresses, this.adminPass, this.flavorId, this.hostId, this.imageId, this.sharedIpGroupId, this.progress, this.status);
        }

        public T fromServer(Server in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).name(in.getName())).metadata(in.getMetadata())).addresses(in.getAddresses())).adminPass(in.getAdminPass())).flavorId(in.getFlavorId())).hostId(in.getHostId())).imageId(in.getImageId())).sharedIpGroupId(in.getSharedIpGroupId())).progress(in.getProgress())).status(in.getStatus());
        }
    }
}

