/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.binders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudsigma.domain.DriveData;
import org.jclouds.cloudsigma.functions.ListOfMapsToListOfKeyValuesDelimitedByBlankLines;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindDriveDataToPlainTextString
implements Binder {
    private final Function<DriveData, Map<String, String>> createDriveRequestToMap;
    private final ListOfMapsToListOfKeyValuesDelimitedByBlankLines listOfMapsToListOfKeyValuesDelimitedByBlankLines;

    @Inject
    public BindDriveDataToPlainTextString(Function<DriveData, Map<String, String>> createDriveRequestToMap, ListOfMapsToListOfKeyValuesDelimitedByBlankLines listOfMapsToListOfKeyValuesDelimitedByBlankLines) {
        this.createDriveRequestToMap = createDriveRequestToMap;
        this.listOfMapsToListOfKeyValuesDelimitedByBlankLines = listOfMapsToListOfKeyValuesDelimitedByBlankLines;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        Preconditions.checkArgument((boolean)(payload instanceof DriveData), (Object)"this binder is only valid for DriveData!");
        DriveData create = (DriveData)DriveData.class.cast(payload);
        Map map = (Map)this.createDriveRequestToMap.apply((Object)create);
        request.setPayload(this.listOfMapsToListOfKeyValuesDelimitedByBlankLines.apply((Iterable<Map<String, String>>)ImmutableSet.of((Object)map)));
        request.getPayload().getContentMetadata().setContentType("text/plain");
        return request;
    }
}

