/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.jclouds.cloudstack.domain.StorageType;

public class ServiceOffering
implements Comparable<ServiceOffering> {
    private long id;
    private String name;
    @SerializedName(value="displaytext")
    private String displayText;
    private Date created;
    private String domain;
    @SerializedName(value="domainid")
    private long domainId;
    @SerializedName(value="cpunumber")
    private int cpuNumber;
    @SerializedName(value="cpuspeed")
    private int cpuSpeed;
    private int memory;
    @SerializedName(value="offerha")
    private boolean haSupport;
    @SerializedName(value="storagetype")
    private StorageType storageType;
    private String tags;
    @SerializedName(value="defaultuse")
    private boolean defaultUse;
    @SerializedName(value="hosttags")
    private String hostTags;
    @SerializedName(value="issystem")
    private boolean systemOffering;
    @SerializedName(value="limitcpuuse")
    private boolean cpuUseLimited;
    @SerializedName(value="networkrate")
    private long networkRate;
    @SerializedName(value="systemvmtype")
    private boolean systemVmType;

    public static Builder builder() {
        return new Builder();
    }

    public ServiceOffering(long id, String name, String displayText, Date created, String domain, long domainId, int cpuNumber, int cpuSpeed, int memory, boolean haSupport, StorageType storageType, Set<String> tags, boolean defaultUse, String hostTags, boolean systemOffering, boolean cpuUseLimited, long networkRate, boolean systemVmType) {
        this.id = id;
        this.name = name;
        this.displayText = displayText;
        this.created = created;
        this.domain = domain;
        this.domainId = domainId;
        this.cpuNumber = cpuNumber;
        this.cpuSpeed = cpuSpeed;
        this.memory = memory;
        this.haSupport = haSupport;
        this.storageType = storageType;
        this.tags = tags.size() == 0 ? null : Joiner.on((char)',').join(tags);
    }

    ServiceOffering() {
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getDomain() {
        return this.domain;
    }

    public long getDomainId() {
        return this.domainId;
    }

    public int getCpuNumber() {
        return this.cpuNumber;
    }

    public int getCpuSpeed() {
        return this.cpuSpeed;
    }

    public int getMemory() {
        return this.memory;
    }

    public boolean supportsHA() {
        return this.haSupport;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public boolean isDefaultUse() {
        return this.defaultUse;
    }

    public String getHostTags() {
        return this.hostTags;
    }

    public boolean isSystemOffering() {
        return this.systemOffering;
    }

    public boolean isCpuUseLimited() {
        return this.cpuUseLimited;
    }

    public long getNetworkRate() {
        return this.networkRate;
    }

    public boolean isSystemVmType() {
        return this.systemVmType;
    }

    public Set<String> getTags() {
        return this.tags != null ? ImmutableSet.copyOf((Iterable)Splitter.on((char)',').split((CharSequence)this.tags)) : ImmutableSet.of();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.cpuNumber;
        result = 31 * result + this.cpuSpeed;
        result = 31 * result + (this.created == null ? 0 : this.created.hashCode());
        result = 31 * result + (this.displayText == null ? 0 : this.displayText.hashCode());
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (int)(this.domainId ^ this.domainId >>> 32);
        result = 31 * result + (this.haSupport ? 1231 : 1237);
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.memory;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.storageType == null ? 0 : this.storageType.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceOffering other = (ServiceOffering)obj;
        if (this.cpuNumber != other.cpuNumber) {
            return false;
        }
        if (this.cpuSpeed != other.cpuSpeed) {
            return false;
        }
        if (this.created == null ? other.created != null : !this.created.equals(other.created)) {
            return false;
        }
        if (this.displayText == null ? other.displayText != null : !this.displayText.equals(other.displayText)) {
            return false;
        }
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.domainId != other.domainId) {
            return false;
        }
        if (this.haSupport != other.haSupport) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.memory != other.memory) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.storageType != other.storageType) {
            return false;
        }
        return !(this.tags == null ? other.tags != null : !this.tags.equals(other.tags));
    }

    public String toString() {
        return "ServiceOffering{id=" + this.id + ", name='" + this.name + '\'' + ", displayText='" + this.displayText + '\'' + ", created=" + this.created + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", cpuNumber=" + this.cpuNumber + ", cpuSpeed=" + this.cpuSpeed + ", memory=" + this.memory + ", haSupport=" + this.haSupport + ", storageType=" + (Object)((Object)this.storageType) + ", tags='" + this.tags + '\'' + ", defaultUse=" + this.defaultUse + ", hostTags='" + this.hostTags + '\'' + ", systemOffering=" + this.systemOffering + ", cpuUseLimited=" + this.cpuUseLimited + ", networkRate=" + this.networkRate + ", systemVmType=" + this.systemVmType + '}';
    }

    @Override
    public int compareTo(ServiceOffering arg0) {
        return new Long(this.id).compareTo(arg0.getId());
    }

    public static class Builder {
        private long id;
        private String name;
        private String displayText;
        private Date created;
        private String domain;
        private long domainId;
        private int cpuNumber;
        private int cpuSpeed;
        private int memory;
        private boolean haSupport;
        private StorageType storageType;
        private boolean defaultUse;
        private String hostTags;
        private boolean systemOffering;
        private boolean cpuUseLimited;
        private long networkRate;
        private boolean systemVmType;
        private Set<String> tags = ImmutableSet.of();

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder displayText(String displayText) {
            this.displayText = displayText;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(long domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder cpuNumber(int cpuNumber) {
            this.cpuNumber = cpuNumber;
            return this;
        }

        public Builder cpuSpeed(int cpuSpeed) {
            this.cpuSpeed = cpuSpeed;
            return this;
        }

        public Builder memory(int memory) {
            this.memory = memory;
            return this;
        }

        public Builder haSupport(boolean haSupport) {
            this.haSupport = haSupport;
            return this;
        }

        public Builder storageType(StorageType storageType) {
            this.storageType = storageType;
            return this;
        }

        public Builder tags(Set<String> tags) {
            this.tags = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(tags, (Object)"tags")));
            return this;
        }

        public Builder defaultUse(boolean defaultUse) {
            this.defaultUse = defaultUse;
            return this;
        }

        public Builder hostTags(String hostTags) {
            this.hostTags = hostTags;
            return this;
        }

        public Builder systemOffering(boolean systemOffering) {
            this.systemOffering = systemOffering;
            return this;
        }

        public Builder cpuUseLimited(boolean cpuUseLimited) {
            this.cpuUseLimited = cpuUseLimited;
            return this;
        }

        public Builder networkRate(long networkRate) {
            this.networkRate = networkRate;
            return this;
        }

        public Builder systemVmType(boolean systemVmType) {
            this.systemVmType = systemVmType;
            return this;
        }

        public ServiceOffering build() {
            return new ServiceOffering(this.id, this.name, this.displayText, this.created, this.domain, this.domainId, this.cpuNumber, this.cpuSpeed, this.memory, this.haSupport, this.storageType, this.tags, this.defaultUse, this.hostTags, this.systemOffering, this.cpuUseLimited, this.networkRate, this.systemVmType);
        }
    }
}

