/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.cloudstack.domain.ApiKeyPair;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.cloudstack.features.DomainUserAsyncClient;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.CreateUserOptions;
import org.jclouds.cloudstack.options.UpdateUserOptions;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface GlobalUserAsyncClient
extends DomainUserAsyncClient {
    @GET
    @QueryParams(keys={"command"}, values={"createUser"})
    @SelectJson(value="user")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<User> createUser(@QueryParam(value="username") String var1, @QueryParam(value="account") String var2, @QueryParam(value="email") String var3, @QueryParam(value="password") String var4, @QueryParam(value="firstname") String var5, @QueryParam(value="lastname") String var6, CreateUserOptions ... var7);

    @GET
    @QueryParams(keys={"command"}, values={"registerUserKeys"})
    @SelectJson(value="userkeys")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<ApiKeyPair> registerUserKeys(@QueryParam(value="id") long var1);

    @GET
    @QueryParams(keys={"command"}, values={"updateUser"})
    @SelectJson(value="user")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<User> updateUser(@QueryParam(value="id") long var1, UpdateUserOptions ... var3);

    @GET
    @QueryParams(keys={"command"}, values={"deleteUser"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteUser(@QueryParam(value="id") long var1);
}

