/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.cloudstack.domain.VlanIPRange;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.CreateVlanIPRangeOptions;
import org.jclouds.cloudstack.options.ListVlanIPRangesOptions;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface GlobalVlanAsyncClient {
    @GET
    @QueryParams(keys={"command"}, values={"listVlanIpRanges"})
    @SelectJson(value="vlaniprange")
    @OnlyElement
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<VlanIPRange> getVlanIPRange(@QueryParam(value="id") long var1);

    @GET
    @QueryParams(keys={"command"}, values={"listVlanIpRanges"})
    @SelectJson(value="vlaniprange")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<VlanIPRange>> listVlanIPRanges(ListVlanIPRangesOptions ... var1);

    @GET
    @QueryParams(keys={"command"}, values={"createVlanIpRange"})
    @SelectJson(value="vlaniprange")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<VlanIPRange> createVlanIPRange(@QueryParam(value="startip") String var1, @QueryParam(value="endip") String var2, CreateVlanIPRangeOptions ... var3);

    @GET
    @QueryParams(keys={"command"}, values={"deleteVlanIpRange"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteVlanIPRange(@QueryParam(value="id") long var1);
}

