/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.cloudstack.domain.VMGroup;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.CreateVMGroupOptions;
import org.jclouds.cloudstack.options.ListVMGroupsOptions;
import org.jclouds.cloudstack.options.UpdateVMGroupOptions;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface VMGroupAsyncClient {
    @GET
    @QueryParams(keys={"command"}, values={"listInstanceGroups"})
    @SelectJson(value="instancegroup")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<VMGroup>> listInstanceGroups(ListVMGroupsOptions ... var1);

    @GET
    @QueryParams(keys={"command"}, values={"listInstanceGroups"})
    @SelectJson(value="instancegroup")
    @OnlyElement
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<VMGroup> getInstanceGroup(@QueryParam(value="id") long var1);

    @GET
    @QueryParams(keys={"command"}, values={"createInstanceGroup"})
    @SelectJson(value="instancegroup")
    @Consumes(value={"application/json"})
    public ListenableFuture<VMGroup> createInstanceGroup(@QueryParam(value="name") String var1, CreateVMGroupOptions ... var2);

    @GET
    @QueryParams(keys={"command"}, values={"updateInstanceGroup"})
    @SelectJson(value="instancegroup")
    @Consumes(value={"application/json"})
    public ListenableFuture<VMGroup> updateInstanceGroup(@QueryParam(value="id") long var1, UpdateVMGroupOptions ... var3);

    @GET
    @QueryParams(keys={"command"}, values={"deleteInstanceGroup"})
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteInstanceGroup(@QueryParam(value="id") long var1);
}

