/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import java.util.Date;

public class Alert
implements Comparable<Alert> {
    private String id;
    private String description;
    private Date sent;
    private String type;

    public static Builder builder() {
        return new Builder();
    }

    Alert() {
    }

    private Alert(String id, String description, Date sent, String type) {
        this.id = id;
        this.description = description;
        this.sent = sent;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getSent() {
        return this.sent;
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Alert that = (Alert)o;
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.description, (Object)that.description)) {
            return false;
        }
        if (!Objects.equal((Object)this.sent, (Object)that.sent)) {
            return false;
        }
        return Objects.equal((Object)this.type, (Object)that.type);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.description, this.sent, this.type});
    }

    public String toString() {
        return "Alert{id=" + this.id + ", description='" + this.description + '\'' + ", sent=" + this.sent + ", type='" + this.type + '\'' + '}';
    }

    @Override
    public int compareTo(Alert other) {
        return this.getId().compareTo(other.getId());
    }

    public static class Builder {
        private String id;
        private String description;
        private Date sent;
        private String type;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder sent(Date sent) {
            this.sent = sent;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Alert build() {
            return new Alert(this.id, this.description, this.sent, this.type);
        }
    }
}

