/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.gson.annotations.SerializedName;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.jclouds.cloudstack.domain.GuestIPType;
import org.jclouds.cloudstack.domain.NetworkService;
import org.jclouds.cloudstack.domain.TrafficType;

public class Network
implements Comparable<Network> {
    private String id;
    private String account;
    @SerializedName(value="broadcastdomaintype")
    private String broadcastDomainType;
    @SerializedName(value="broadcasturi")
    private URI broadcastURI;
    @SerializedName(value="displaytext")
    private String displayText;
    @SerializedName(value="dns1")
    private String DNS1;
    @SerializedName(value="dns2")
    private String DNS2;
    private String domain;
    @SerializedName(value="domainid")
    private String domainId;
    @SerializedName(value="endip")
    private String endIP;
    private String gateway;
    @SerializedName(value="isdefault")
    private boolean isDefault;
    @SerializedName(value="isshared")
    private boolean isShared;
    @SerializedName(value="issystem")
    private boolean isSystem;
    private String netmask;
    @Nullable
    @SerializedName(value="networkdomain")
    private String networkDomain;
    @SerializedName(value="networkofferingavailability")
    private String networkOfferingAvailability;
    @SerializedName(value="networkofferingdisplaytext")
    private String networkOfferingDisplayText;
    @SerializedName(value="networkofferingid")
    private String networkOfferingId;
    @SerializedName(value="networkofferingname")
    private String networkOfferingName;
    private String related;
    @SerializedName(value="startip")
    private String startIP;
    private String name;
    private String state;
    @SerializedName(value="type")
    private GuestIPType guestIPType;
    @SerializedName(value="vlan")
    private String VLAN;
    @SerializedName(value="traffictype")
    private TrafficType trafficType;
    @SerializedName(value="zoneid")
    private String zoneId;
    private String tags;
    @SerializedName(value="securitygroupenabled")
    private boolean securityGroupEnabled;
    @SerializedName(value="service")
    private SortedSet<? extends NetworkService> services = ImmutableSortedSet.of();

    public static Builder builder() {
        return new Builder();
    }

    Network() {
    }

    public Network(String id, String broadcastDomainType, URI broadcastURI, String displayText, List<String> DNS, String domain, String domainId, String endIP, String gateway, boolean isDefault, boolean isShared, boolean isSystem, String netmask, String networkDomain, String networkOfferingAvailability, String networkOfferingDisplayText, String networkOfferingId, String networkOfferingName, String related, String startIP, String name, String state, GuestIPType type, String vLAN, TrafficType trafficType, String zoneId, Set<? extends NetworkService> services, Set<String> tags, boolean securityGroupEnabled, String account) {
        this.id = id;
        this.broadcastDomainType = broadcastDomainType;
        this.broadcastURI = broadcastURI;
        this.displayText = displayText;
        this.DNS1 = ((List)Preconditions.checkNotNull(DNS, (Object)"DNS")).size() > 0 ? DNS.get(0) : null;
        this.DNS2 = DNS.size() > 1 ? DNS.get(1) : null;
        this.domain = domain;
        this.domainId = domainId;
        this.endIP = endIP;
        this.gateway = gateway;
        this.isDefault = isDefault;
        this.isShared = isShared;
        this.isSystem = isSystem;
        this.netmask = netmask;
        this.networkDomain = networkDomain;
        this.networkOfferingAvailability = networkOfferingAvailability;
        this.networkOfferingDisplayText = networkOfferingDisplayText;
        this.networkOfferingId = networkOfferingId;
        this.networkOfferingName = networkOfferingName;
        this.related = related;
        this.startIP = startIP;
        this.name = name;
        this.state = state;
        this.guestIPType = type;
        this.VLAN = vLAN;
        this.trafficType = trafficType;
        this.zoneId = zoneId;
        this.services = ImmutableSortedSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(services, (Object)"services")));
        this.tags = tags.size() == 0 ? null : Joiner.on((char)',').join(tags);
        this.securityGroupEnabled = securityGroupEnabled;
        this.account = account;
    }

    public String getId() {
        return this.id;
    }

    public String getBroadcastDomainType() {
        return this.broadcastDomainType;
    }

    public URI getBroadcastURI() {
        return this.broadcastURI;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public List<String> getDNS() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.DNS1 != null && !"".equals(this.DNS1)) {
            builder.add((Object)this.DNS1);
        }
        if (this.DNS2 != null && !"".equals(this.DNS2)) {
            builder.add((Object)this.DNS2);
        }
        return builder.build();
    }

    public String getDomain() {
        return this.domain;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public String getAccount() {
        return this.account;
    }

    public String getEndIP() {
        return this.endIP;
    }

    public String getGateway() {
        return this.gateway;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public String getName() {
        return this.name;
    }

    public GuestIPType getGuestIPType() {
        return this.guestIPType;
    }

    public String getState() {
        return this.state;
    }

    public String getVLAN() {
        return this.VLAN;
    }

    public TrafficType getTrafficType() {
        return this.trafficType;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public String getNetworkDomain() {
        return this.networkDomain;
    }

    public String getNetworkOfferingAvailability() {
        return this.networkOfferingAvailability;
    }

    public String getNetworkOfferingDisplayText() {
        return this.networkOfferingDisplayText;
    }

    public String getNetworkOfferingId() {
        return this.networkOfferingId;
    }

    public String getNetworkOfferingName() {
        return this.networkOfferingName;
    }

    public String getRelated() {
        return this.related;
    }

    public String getStartIP() {
        return this.startIP;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public Set<? extends NetworkService> getServices() {
        return this.services;
    }

    public boolean isSecurityGroupEnabled() {
        return this.securityGroupEnabled;
    }

    public Set<String> getTags() {
        return this.tags != null ? ImmutableSet.copyOf((Iterable)Splitter.on((char)',').split((CharSequence)this.tags)) : ImmutableSet.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Network that = (Network)o;
        if (!Objects.equal((Object)this.DNS1, (Object)that.DNS1)) {
            return false;
        }
        if (!Objects.equal((Object)this.DNS2, (Object)that.DNS2)) {
            return false;
        }
        if (!Objects.equal((Object)this.VLAN, (Object)that.VLAN)) {
            return false;
        }
        if (!Objects.equal((Object)this.broadcastDomainType, (Object)that.broadcastDomainType)) {
            return false;
        }
        if (!Objects.equal((Object)this.broadcastURI, (Object)that.broadcastURI)) {
            return false;
        }
        if (!Objects.equal((Object)this.displayText, (Object)that.displayText)) {
            return false;
        }
        if (!Objects.equal((Object)this.domain, (Object)that.domain)) {
            return false;
        }
        if (!Objects.equal((Object)this.endIP, (Object)that.endIP)) {
            return false;
        }
        if (!Objects.equal((Object)this.gateway, (Object)that.gateway)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.guestIPType), (Object)((Object)that.guestIPType))) {
            return false;
        }
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.isDefault, (Object)that.isDefault)) {
            return false;
        }
        if (!Objects.equal((Object)this.isShared, (Object)that.isShared)) {
            return false;
        }
        if (!Objects.equal((Object)this.isSystem, (Object)that.isSystem)) {
            return false;
        }
        if (!Objects.equal((Object)this.name, (Object)that.name)) {
            return false;
        }
        if (!Objects.equal((Object)this.netmask, (Object)that.netmask)) {
            return false;
        }
        if (!Objects.equal((Object)this.networkDomain, (Object)that.networkDomain)) {
            return false;
        }
        if (!Objects.equal((Object)this.networkOfferingAvailability, (Object)that.networkOfferingAvailability)) {
            return false;
        }
        if (!Objects.equal((Object)this.networkOfferingDisplayText, (Object)that.networkOfferingDisplayText)) {
            return false;
        }
        if (!Objects.equal((Object)this.networkOfferingId, (Object)that.networkOfferingId)) {
            return false;
        }
        if (!Objects.equal((Object)this.networkOfferingName, (Object)that.networkOfferingName)) {
            return false;
        }
        if (!Objects.equal((Object)this.related, (Object)that.related)) {
            return false;
        }
        if (!Objects.equal(this.services, that.services)) {
            return false;
        }
        if (!Objects.equal((Object)this.startIP, (Object)that.startIP)) {
            return false;
        }
        if (!Objects.equal((Object)this.state, (Object)that.state)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.trafficType), (Object)((Object)that.trafficType))) {
            return false;
        }
        if (!Objects.equal((Object)this.zoneId, (Object)that.zoneId)) {
            return false;
        }
        if (!Objects.equal((Object)this.tags, (Object)that.tags)) {
            return false;
        }
        return Objects.equal((Object)this.domainId, (Object)that.domainId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.DNS1, this.DNS2, this.VLAN, this.broadcastDomainType, this.broadcastURI, this.displayText, this.domain, this.endIP, this.gateway, this.guestIPType, this.id, this.isDefault, this.isShared, this.isSystem, this.name, this.netmask, this.networkDomain, this.networkOfferingAvailability, this.networkOfferingDisplayText, this.networkOfferingId, this.networkOfferingName, this.related, this.services, this.startIP, this.state, this.trafficType, this.zoneId, this.tags, this.domainId});
    }

    public String toString() {
        return "Network{id=" + this.id + ", account='" + this.account + '\'' + ", broadcastDomainType='" + this.broadcastDomainType + '\'' + ", broadcastURI=" + this.broadcastURI + ", displayText='" + this.displayText + '\'' + ", DNS1='" + this.DNS1 + '\'' + ", DNS2='" + this.DNS2 + '\'' + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", endIP='" + this.endIP + '\'' + ", gateway='" + this.gateway + '\'' + ", isDefault=" + this.isDefault + ", isShared=" + this.isShared + ", isSystem=" + this.isSystem + ", netmask='" + this.netmask + '\'' + ", networkDomain='" + this.networkDomain + '\'' + ", networkOfferingAvailability='" + this.networkOfferingAvailability + '\'' + ", networkOfferingDisplayText='" + this.networkOfferingDisplayText + '\'' + ", networkOfferingId=" + this.networkOfferingId + ", networkOfferingName='" + this.networkOfferingName + '\'' + ", related=" + this.related + ", startIP='" + this.startIP + '\'' + ", name='" + this.name + '\'' + ", state='" + this.state + '\'' + ", guestIPType=" + (Object)((Object)this.guestIPType) + ", VLAN='" + this.VLAN + '\'' + ", trafficType=" + (Object)((Object)this.trafficType) + ", zoneId=" + this.zoneId + ", tags='" + this.tags + '\'' + ", securityGroupEnabled=" + this.securityGroupEnabled + ", services=" + this.services + '}';
    }

    @Override
    public int compareTo(Network arg0) {
        return this.id.compareTo(arg0.getId());
    }

    public static class Builder {
        private String id;
        private String broadcastDomainType;
        private URI broadcastURI;
        private String displayText;
        private List<String> DNS = ImmutableList.of();
        private String domain;
        private String endIP;
        private String gateway;
        private boolean isDefault;
        private boolean isShared;
        private boolean isSystem;
        private String netmask;
        private String networkDomain;
        private String networkOfferingAvailability;
        private String networkOfferingDisplayText;
        private String networkOfferingId;
        private String networkOfferingName;
        private String related;
        private String startIP;
        private String name;
        private String state;
        private GuestIPType guestIPType;
        private String VLAN;
        private TrafficType trafficType;
        private String zoneId;
        private Set<? extends NetworkService> services = ImmutableSet.of();
        private String account;
        private String domainId;
        private boolean securityGroupEnabled;
        private Set<String> tags = ImmutableSet.of();

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder broadcastDomainType(String broadcastDomainType) {
            this.broadcastDomainType = broadcastDomainType;
            return this;
        }

        public Builder broadcastURI(URI broadcastURI) {
            this.broadcastURI = broadcastURI;
            return this;
        }

        public Builder displayText(String displayText) {
            this.displayText = displayText;
            return this;
        }

        public Builder DNS(List<String> DNS) {
            this.DNS = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(DNS, (Object)"DNS")));
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder endIP(String endIP) {
            this.endIP = endIP;
            return this;
        }

        public Builder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        public Builder isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public Builder isShared(boolean isShared) {
            this.isShared = isShared;
            return this;
        }

        public Builder isSystem(boolean isSystem) {
            this.isSystem = isSystem;
            return this;
        }

        public Builder netmask(String netmask) {
            this.netmask = netmask;
            return this;
        }

        public Builder networkDomain(String networkDomain) {
            this.networkDomain = networkDomain;
            return this;
        }

        public Builder networkOfferingAvailability(String networkOfferingAvailability) {
            this.networkOfferingAvailability = networkOfferingAvailability;
            return this;
        }

        public Builder networkOfferingDisplayText(String networkOfferingDisplayText) {
            this.networkOfferingDisplayText = networkOfferingDisplayText;
            return this;
        }

        public Builder networkOfferingId(String networkOfferingId) {
            this.networkOfferingId = networkOfferingId;
            return this;
        }

        public Builder networkOfferingName(String networkOfferingName) {
            this.networkOfferingName = networkOfferingName;
            return this;
        }

        public Builder related(String related) {
            this.related = related;
            return this;
        }

        public Builder startIP(String startIP) {
            this.startIP = startIP;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder guestIPType(GuestIPType guestIPType) {
            this.guestIPType = guestIPType;
            return this;
        }

        public Builder VLAN(String VLAN) {
            this.VLAN = VLAN;
            return this;
        }

        public Builder trafficType(TrafficType trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder services(Set<? extends NetworkService> services) {
            this.services = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(services, (Object)"services")));
            return this;
        }

        public Builder tags(Set<String> tags) {
            this.tags = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(tags, (Object)"tags")));
            return this;
        }

        public Builder securityGroupEnabled(boolean securityGroupEnabled) {
            this.securityGroupEnabled = securityGroupEnabled;
            return this;
        }

        public Network build() {
            return new Network(this.id, this.broadcastDomainType, this.broadcastURI, this.displayText, this.DNS, this.domain, this.domainId, this.endIP, this.gateway, this.isDefault, this.isShared, this.isSystem, this.netmask, this.networkDomain, this.networkOfferingAvailability, this.networkOfferingDisplayText, this.networkOfferingId, this.networkOfferingName, this.related, this.startIP, this.name, this.state, this.guestIPType, this.VLAN, this.trafficType, this.zoneId, this.services, this.tags, this.securityGroupEnabled, this.account);
        }
    }
}

