/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.SerializedName;
import java.util.Set;

public class PortForwardingRule
implements Comparable<PortForwardingRule> {
    private String id;
    @SerializedName(value="ipaddress")
    private String IPAddress;
    @SerializedName(value="ipaddressid")
    private String IPAddressId;
    @SerializedName(value="privateport")
    private int privatePort;
    private Protocol protocol;
    @SerializedName(value="publicport")
    public int publicPort;
    private State state;
    @SerializedName(value="virtualmachinedisplayname")
    private String virtualMachineDisplayName;
    @SerializedName(value="virtualmachineid")
    public String virtualMachineId;
    @SerializedName(value="virtualmachinename")
    private String virtualMachineName;
    @SerializedName(value="cidrlist")
    private Set<String> CIDRs;
    @SerializedName(value="privateendport")
    private int privateEndPort;
    @SerializedName(value="publicendport")
    private int publicEndPort;

    public static Builder builder() {
        return new Builder();
    }

    public PortForwardingRule(String id, String iPAddress, String iPAddressId, int privatePort, Protocol protocol, int publicPort, State state, String virtualMachineDisplayName, String virtualMachineId, String virtualMachineName, Set<String> CIDRs, int privateEndPort, int publicEndPort) {
        this.id = id;
        this.IPAddress = iPAddress;
        this.IPAddressId = iPAddressId;
        this.privatePort = privatePort;
        this.protocol = protocol;
        this.publicPort = publicPort;
        this.state = state;
        this.virtualMachineDisplayName = virtualMachineDisplayName;
        this.virtualMachineId = virtualMachineId;
        this.virtualMachineName = virtualMachineName;
        this.CIDRs = CIDRs;
        this.privateEndPort = privateEndPort;
        this.publicEndPort = publicEndPort;
    }

    @Override
    public int compareTo(PortForwardingRule arg0) {
        return this.id.compareTo(arg0.getId());
    }

    public String getId() {
        return this.id;
    }

    public String getIPAddress() {
        return this.IPAddress;
    }

    public String getIPAddressId() {
        return this.IPAddressId;
    }

    public int getPrivatePort() {
        return this.privatePort;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public int getPublicPort() {
        return this.publicPort;
    }

    public State getState() {
        return this.state;
    }

    public String getVirtualMachineDisplayName() {
        return this.virtualMachineDisplayName;
    }

    public String getVirtualMachineId() {
        return this.virtualMachineId;
    }

    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    public Set<String> getCIDRs() {
        return this.CIDRs;
    }

    public int getPrivateEndPort() {
        return this.privateEndPort;
    }

    public int getPublicEndPort() {
        return this.publicEndPort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortForwardingRule that = (PortForwardingRule)o;
        if (!Objects.equal((Object)this.IPAddress, (Object)that.IPAddress)) {
            return false;
        }
        if (!Objects.equal((Object)this.IPAddressId, (Object)that.IPAddressId)) {
            return false;
        }
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.privatePort, (Object)that.privatePort)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.protocol), (Object)((Object)that.protocol))) {
            return false;
        }
        if (!Objects.equal((Object)this.publicPort, (Object)that.publicPort)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.state), (Object)((Object)that.state))) {
            return false;
        }
        if (!Objects.equal((Object)this.virtualMachineDisplayName, (Object)that.virtualMachineDisplayName)) {
            return false;
        }
        if (!Objects.equal((Object)this.virtualMachineId, (Object)that.virtualMachineId)) {
            return false;
        }
        return Objects.equal((Object)this.virtualMachineName, (Object)that.virtualMachineName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.IPAddress, this.IPAddressId, this.id, this.privatePort, this.protocol, this.publicPort, this.state, this.virtualMachineDisplayName, this.virtualMachineId, this.virtualMachineName});
    }

    public String toString() {
        return "PortForwardingRule{id=" + this.id + ", IPAddress='" + this.IPAddress + '\'' + ", IPAddressId=" + this.IPAddressId + ", privatePort=" + this.privatePort + ", protocol='" + (Object)((Object)this.protocol) + '\'' + ", publicPort=" + this.publicPort + ", state='" + (Object)((Object)this.state) + '\'' + ", virtualMachineDisplayName='" + this.virtualMachineDisplayName + '\'' + ", virtualMachineId=" + this.virtualMachineId + ", virtualMachineName='" + this.virtualMachineName + '\'' + ", CIDRs=" + this.getCIDRs() + ", privateEndPort=" + this.privateEndPort + ", publicEndPort=" + this.publicEndPort + '}';
    }

    public static class Builder {
        private String id;
        private String IPAddress;
        private String IPAddressId;
        private int privatePort;
        private Protocol protocol;
        public int publicPort;
        private State state;
        private String virtualMachineDisplayName;
        public String virtualMachineId;
        private String virtualMachineName;
        private Set<String> CIDRs = ImmutableSet.of();
        private int privateEndPort;
        private int publicEndPort;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder IPAddress(String IPAddress) {
            this.IPAddress = IPAddress;
            return this;
        }

        public Builder IPAddressId(String IPAddressId) {
            this.IPAddressId = IPAddressId;
            return this;
        }

        public Builder privatePort(int privatePort) {
            this.privatePort = privatePort;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder publicPort(int publicPort) {
            this.publicPort = publicPort;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder virtualMachineDisplayName(String virtualMachineDisplayName) {
            this.virtualMachineDisplayName = virtualMachineDisplayName;
            return this;
        }

        public Builder virtualMachineId(String virtualMachineId) {
            this.virtualMachineId = virtualMachineId;
            return this;
        }

        public Builder virtualMachineName(String virtualMachineName) {
            this.virtualMachineName = virtualMachineName;
            return this;
        }

        public Builder CIDRs(Set<String> CIDRs) {
            this.CIDRs = CIDRs;
            return this;
        }

        public Builder privateEndPort(int privateEndPort) {
            this.privateEndPort = privateEndPort;
            return this;
        }

        public Builder publicEndPort(int publicEndPort) {
            this.publicEndPort = publicEndPort;
            return this;
        }

        public PortForwardingRule build() {
            return new PortForwardingRule(this.id, this.IPAddress, this.IPAddressId, this.privatePort, this.protocol, this.publicPort, this.state, this.virtualMachineDisplayName, this.virtualMachineId, this.virtualMachineName, this.CIDRs, this.privateEndPort, this.publicEndPort);
        }
    }

    public static enum State {
        STAGED,
        ADD,
        ACTIVE,
        DELETEING,
        UNKNOWN;


        public static State fromValue(String value) {
            try {
                return State.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }

    public static enum Protocol {
        TCP,
        UDP,
        ICMP,
        UNKNOWN;


        public static Protocol fromValue(String value) {
            try {
                return Protocol.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

