/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import org.jclouds.cloudstack.domain.Volume;

public class Snapshot
implements Comparable<Snapshot> {
    private String id;
    private String account;
    private Date created;
    private String domain;
    @SerializedName(value="domainid")
    private String domainId;
    @SerializedName(value="intervaltype")
    private Interval interval;
    @SerializedName(value="jobid")
    private String jobId;
    @SerializedName(value="jobstatus")
    private String jobStatus;
    private String name;
    @SerializedName(value="snapshottype")
    private Type snapshotType;
    private State state;
    @SerializedName(value="volumeid")
    private String volumeId;
    @SerializedName(value="volumename")
    private String volumeName;
    @SerializedName(value="volumetype")
    private Volume.Type volumeType;

    public static Builder builder() {
        return new Builder();
    }

    public Snapshot(String id, String account, Date created, String domain, String domainId, Interval interval, String jobId, String jobStatus, String name, Type snapshotType, State state, String volumeId, String volumeName, Volume.Type volumeType) {
        this.id = id;
        this.account = account;
        this.created = created;
        this.domain = domain;
        this.domainId = domainId;
        this.interval = interval;
        this.jobId = jobId;
        this.jobStatus = jobStatus;
        this.name = name;
        this.snapshotType = snapshotType;
        this.state = state;
        this.volumeId = volumeId;
        this.volumeName = volumeName;
        this.volumeType = volumeType;
    }

    Snapshot() {
    }

    public String getId() {
        return this.id;
    }

    public String getAccount() {
        return this.account;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public String getName() {
        return this.name;
    }

    public Type getSnapshotType() {
        return this.snapshotType;
    }

    public State getState() {
        return this.state;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public Volume.Type getVolumeType() {
        return this.volumeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Snapshot that = (Snapshot)o;
        if (!Objects.equal((Object)this.domainId, (Object)that.domainId)) {
            return false;
        }
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.jobId, (Object)that.jobId)) {
            return false;
        }
        if (!Objects.equal((Object)this.volumeId, (Object)that.volumeId)) {
            return false;
        }
        if (!Objects.equal((Object)this.account, (Object)that.account)) {
            return false;
        }
        if (!Objects.equal((Object)this.created, (Object)that.created)) {
            return false;
        }
        if (!Objects.equal((Object)this.domain, (Object)that.domain)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.interval), (Object)((Object)that.interval))) {
            return false;
        }
        if (!Objects.equal((Object)this.jobStatus, (Object)that.jobStatus)) {
            return false;
        }
        if (!Objects.equal((Object)this.name, (Object)that.name)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.snapshotType), (Object)((Object)that.snapshotType))) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.state), (Object)((Object)that.state))) {
            return false;
        }
        if (!Objects.equal((Object)this.volumeName, (Object)that.volumeName)) {
            return false;
        }
        return Objects.equal((Object)((Object)this.volumeType), (Object)((Object)that.volumeType));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.domainId, this.id, this.jobId, this.volumeId, this.account, this.created, this.domain, this.interval, this.jobStatus, this.name, this.snapshotType, this.state, this.volumeName, this.volumeType});
    }

    public String toString() {
        return "Snapshot{id=" + this.id + ", account='" + this.account + '\'' + ", created=" + this.created + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", interval=" + (Object)((Object)this.interval) + ", jobId=" + this.jobId + ", jobStatus='" + this.jobStatus + '\'' + ", name='" + this.name + '\'' + ", snapshotType=" + (Object)((Object)this.snapshotType) + ", state=" + (Object)((Object)this.state) + ", volumeId=" + this.volumeId + ", volumeName='" + this.volumeName + '\'' + ", volumeType=" + (Object)((Object)this.volumeType) + '}';
    }

    @Override
    public int compareTo(Snapshot other) {
        return this.id.compareTo(other.getId());
    }

    public static enum Interval {
        HOURLY,
        DAILY,
        WEEKLY,
        MONTHLY,
        template,
        none,
        UNRECOGNIZED;


        public static Interval fromValue(String type) {
            try {
                return Interval.valueOf((String)Preconditions.checkNotNull((Object)type, (Object)"type"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum Type {
        MANUAL,
        RECURRING,
        UNRECOGNIZED;


        public static Type fromValue(String type) {
            try {
                return Type.valueOf((String)Preconditions.checkNotNull((Object)type, (Object)"type"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum State {
        BACKED_UP,
        CREATING,
        BACKING_UP,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)state, (Object)"state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static class Builder {
        private String id;
        private String account;
        private Date created;
        private String domain;
        private String domainId;
        private Interval interval;
        private String jobId;
        private String jobStatus;
        private String name;
        private Type snapshotType;
        private State state;
        private String volumeId;
        private String volumeName;
        private Volume.Type volumeType;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder interval(Interval interval) {
            this.interval = interval;
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder snapshotType(Type snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public Builder volumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public Builder volumeType(Volume.Type volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public Snapshot build() {
            return new Snapshot(this.id, this.account, this.created, this.domain, this.domainId, this.interval, this.jobId, this.jobStatus, this.name, this.snapshotType, this.state, this.volumeId, this.volumeName, this.volumeType);
        }
    }
}

