/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import javax.annotation.Nullable;

public class Template
implements Comparable<Template> {
    private String id;
    @SerializedName(value="displaytext")
    private String displayText;
    private String domain;
    @SerializedName(value="domainid")
    private String domainId;
    private String account;
    @SerializedName(value="accountid")
    private String accountId;
    @SerializedName(value="zonename")
    private String zone;
    @SerializedName(value="zoneid")
    private String zoneId;
    @SerializedName(value="ostypename")
    private String OSType;
    @SerializedName(value="ostypeid")
    private String OSTypeId;
    private String name;
    @SerializedName(value="templatetype")
    private Type type;
    private String status;
    private Format format;
    private String hypervisor;
    private Long size;
    private Date created;
    private Date removed;
    @SerializedName(value="crossZones")
    private boolean crossZones;
    @SerializedName(value="bootable")
    private boolean bootable;
    @SerializedName(value="isextractable")
    private boolean extractable;
    @SerializedName(value="isfeatured")
    private boolean featured;
    @SerializedName(value="ispublic")
    private boolean ispublic;
    @SerializedName(value="isready")
    private boolean ready;
    @SerializedName(value="passwordenabled")
    private boolean passwordEnabled;
    @Nullable
    @SerializedName(value="jobid")
    private String jobId;
    @SerializedName(value="jobstatus")
    private String jobStatus;
    private String checksum;
    @SerializedName(value="hostId")
    private String hostId;
    @SerializedName(value="hostname")
    private String hostName;
    @SerializedName(value="sourcetemplateid")
    @Nullable
    private String sourceTemplateId;
    @SerializedName(value="templatetag")
    private String templateTag;

    public static Builder builder() {
        return new Builder();
    }

    public Template(String id, String displayText, String domain, String domainId, String account, String accountId, String zone, String zoneId, String oSType, String oSTypeId, String name, Type type, String status, Format format, String hypervisor, Long size, Date created, Date removed, boolean crossZones, boolean bootable, boolean extractable, boolean featured, boolean ispublic, boolean ready, boolean passwordEnabled, String jobId, String jobStatus, String checksum, String hostId, String hostName, String sourceTemplateId, String templateTag) {
        this.id = id;
        this.displayText = displayText;
        this.domain = domain;
        this.domainId = domainId;
        this.account = account;
        this.accountId = accountId;
        this.zone = zone;
        this.zoneId = zoneId;
        this.OSType = oSType;
        this.OSTypeId = oSTypeId;
        this.name = name;
        this.type = type;
        this.status = status;
        this.format = format;
        this.hypervisor = hypervisor;
        this.size = size;
        this.created = created;
        this.removed = removed;
        this.crossZones = crossZones;
        this.bootable = bootable;
        this.extractable = extractable;
        this.featured = featured;
        this.ispublic = ispublic;
        this.ready = ready;
        this.passwordEnabled = passwordEnabled;
        this.jobId = jobId;
        this.jobStatus = jobStatus;
        this.checksum = checksum;
        this.hostId = hostId;
        this.hostName = hostName;
        this.sourceTemplateId = sourceTemplateId;
        this.templateTag = templateTag;
    }

    Template() {
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public String getAccount() {
        return this.account;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getZone() {
        return this.zone;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public String getOSType() {
        return this.OSType;
    }

    public String getOSTypeId() {
        return this.OSTypeId;
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() {
        return this.status;
    }

    public Format getFormat() {
        return this.format;
    }

    public String getHypervisor() {
        return this.hypervisor;
    }

    public Long getSize() {
        return this.size;
    }

    public Type getType() {
        return this.type;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getRemoved() {
        return this.removed;
    }

    public boolean isCrossZones() {
        return this.crossZones;
    }

    public boolean isBootable() {
        return this.bootable;
    }

    public boolean isExtractable() {
        return this.extractable;
    }

    public boolean isFeatured() {
        return this.featured;
    }

    public boolean isPublic() {
        return this.ispublic;
    }

    public boolean isReady() {
        return this.ready;
    }

    public boolean isPasswordEnabled() {
        return this.passwordEnabled;
    }

    @Nullable
    public String getJobId() {
        return this.jobId;
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public String getHostId() {
        return this.hostId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getSourceTemplateId() {
        return this.sourceTemplateId;
    }

    public String getTemplateTag() {
        return this.templateTag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Template that = (Template)o;
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.displayText, (Object)that.displayText)) {
            return false;
        }
        if (!Objects.equal((Object)this.domain, (Object)that.domain)) {
            return false;
        }
        if (!Objects.equal((Object)this.domainId, (Object)that.domainId)) {
            return false;
        }
        if (!Objects.equal((Object)this.account, (Object)that.account)) {
            return false;
        }
        if (!Objects.equal((Object)this.accountId, (Object)that.accountId)) {
            return false;
        }
        if (!Objects.equal((Object)this.zone, (Object)that.zone)) {
            return false;
        }
        if (!Objects.equal((Object)this.zoneId, (Object)that.zoneId)) {
            return false;
        }
        if (!Objects.equal((Object)this.OSType, (Object)that.OSType)) {
            return false;
        }
        if (!Objects.equal((Object)this.OSTypeId, (Object)that.OSTypeId)) {
            return false;
        }
        if (!Objects.equal((Object)this.name, (Object)that.name)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.type), (Object)((Object)that.type))) {
            return false;
        }
        if (!Objects.equal((Object)this.status, (Object)that.status)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.format), (Object)((Object)that.format))) {
            return false;
        }
        if (!Objects.equal((Object)this.hypervisor, (Object)that.hypervisor)) {
            return false;
        }
        if (!Objects.equal((Object)this.size, (Object)that.size)) {
            return false;
        }
        if (!Objects.equal((Object)this.created, (Object)that.created)) {
            return false;
        }
        if (!Objects.equal((Object)this.removed, (Object)that.removed)) {
            return false;
        }
        if (!Objects.equal((Object)this.crossZones, (Object)that.crossZones)) {
            return false;
        }
        if (!Objects.equal((Object)this.bootable, (Object)that.bootable)) {
            return false;
        }
        if (!Objects.equal((Object)this.extractable, (Object)that.extractable)) {
            return false;
        }
        if (!Objects.equal((Object)this.featured, (Object)that.featured)) {
            return false;
        }
        if (!Objects.equal((Object)this.ispublic, (Object)that.ispublic)) {
            return false;
        }
        if (!Objects.equal((Object)this.ready, (Object)that.ready)) {
            return false;
        }
        if (!Objects.equal((Object)this.passwordEnabled, (Object)that.passwordEnabled)) {
            return false;
        }
        if (!Objects.equal((Object)this.jobId, (Object)that.jobId)) {
            return false;
        }
        if (!Objects.equal((Object)this.jobStatus, (Object)that.jobStatus)) {
            return false;
        }
        if (!Objects.equal((Object)this.checksum, (Object)that.checksum)) {
            return false;
        }
        if (!Objects.equal((Object)this.hostId, (Object)that.hostId)) {
            return false;
        }
        if (!Objects.equal((Object)this.hostName, (Object)that.hostName)) {
            return false;
        }
        if (!Objects.equal((Object)this.sourceTemplateId, (Object)that.sourceTemplateId)) {
            return false;
        }
        return Objects.equal((Object)this.templateTag, (Object)that.templateTag);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.displayText, this.domain, this.domainId, this.account, this.accountId, this.zone, this.zoneId, this.OSType, this.OSTypeId, this.name, this.type, this.status, this.format, this.hypervisor, this.size, this.created, this.removed, this.crossZones, this.bootable, this.extractable, this.featured, this.ispublic, this.ready, this.passwordEnabled, this.jobId, this.jobStatus, this.checksum, this.hostId, this.hostName, this.sourceTemplateId, this.templateTag});
    }

    public String toString() {
        return "Template{id=" + this.id + ", displayText='" + this.displayText + '\'' + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", account='" + this.account + '\'' + ", accountId=" + this.accountId + ", zone='" + this.zone + '\'' + ", zoneId=" + this.zoneId + ", OSType='" + this.OSType + '\'' + ", OSTypeId=" + this.OSTypeId + ", name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + ", status='" + this.status + '\'' + ", format=" + (Object)((Object)this.format) + ", hypervisor='" + this.hypervisor + '\'' + ", size=" + this.size + ", created=" + this.created + ", removed=" + this.removed + ", crossZones=" + this.crossZones + ", bootable=" + this.bootable + ", extractable=" + this.extractable + ", featured=" + this.featured + ", ispublic=" + this.ispublic + ", ready=" + this.ready + ", passwordEnabled=" + this.passwordEnabled + ", jobId=" + this.jobId + ", jobStatus='" + this.jobStatus + '\'' + ", checksum='" + this.checksum + '\'' + ", hostId=" + this.hostId + ", hostName='" + this.hostName + '\'' + ", sourceTemplateId=" + this.sourceTemplateId + ", templateTag='" + this.templateTag + '\'' + '}';
    }

    @Override
    public int compareTo(Template arg0) {
        return this.id.compareTo(arg0.getId());
    }

    public static enum Format {
        VHD,
        QCOW2,
        OVA,
        UNRECOGNIZED;


        public static Format fromValue(String format) {
            try {
                return Format.valueOf((String)Preconditions.checkNotNull((Object)format, (Object)"format"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum Type {
        USER,
        BUILTIN,
        UNRECOGNIZED;


        public static Type fromValue(String type) {
            try {
                return Type.valueOf((String)Preconditions.checkNotNull((Object)type, (Object)"type"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static class Builder {
        private String id;
        private String displayText;
        private String domain;
        private String domainId;
        private String account;
        private String accountId;
        private String zone;
        private String zoneId;
        private String OSType;
        private String OSTypeId;
        private String name;
        private Type type;
        private String status;
        private Format format;
        private String hypervisor;
        private Long size;
        private Date created;
        private Date removed;
        private boolean crossZones;
        private boolean bootable;
        private boolean extractable;
        private boolean featured;
        private boolean isPublic;
        private boolean ready;
        private boolean passwordEnabled;
        private String jobId;
        private String jobStatus;
        private String checksum;
        private String hostId;
        private String hostName;
        private String sourceTemplateId;
        private String templateTag;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder displayText(String displayText) {
            this.displayText = displayText;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder zone(String zone) {
            this.zone = zone;
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder OSType(String OSType2) {
            this.OSType = OSType2;
            return this;
        }

        public Builder OSTypeId(String OSTypeId) {
            this.OSTypeId = OSTypeId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder format(Format format) {
            this.format = format;
            return this;
        }

        public Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder removed(Date removed) {
            this.removed = removed;
            return this;
        }

        public Builder crossZones(boolean crossZones) {
            this.crossZones = crossZones;
            return this;
        }

        public Builder bootable(boolean bootable) {
            this.bootable = bootable;
            return this;
        }

        public Builder extractable(boolean extractable) {
            this.extractable = extractable;
            return this;
        }

        public Builder featured(boolean featured) {
            this.featured = featured;
            return this;
        }

        public Builder isPublic(boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        public Builder ready(boolean ready) {
            this.ready = ready;
            return this;
        }

        public Builder passwordEnabled(boolean passwordEnabled) {
            this.passwordEnabled = passwordEnabled;
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        public Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public Builder hostid(String hostid) {
            this.hostId = hostid;
            return this;
        }

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder sourceTemplateId(String sourceTemplateId) {
            this.sourceTemplateId = sourceTemplateId;
            return this;
        }

        public Builder templateTag(String templateTag) {
            this.templateTag = templateTag;
            return this;
        }

        public Template build() {
            return new Template(this.id, this.displayText, this.domain, this.domainId, this.account, this.accountId, this.zone, this.zoneId, this.OSType, this.OSTypeId, this.name, this.type, this.status, this.format, this.hypervisor, this.size, this.created, this.removed, this.crossZones, this.bootable, this.extractable, this.featured, this.isPublic, this.ready, this.passwordEnabled, this.jobId, this.jobStatus, this.checksum, this.hostId, this.hostName, this.sourceTemplateId, this.templateTag);
        }
    }
}

