/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;

public class TemplatePermission
implements Comparable<TemplatePermission> {
    private String id;
    private String account;
    @SerializedName(value="domainid")
    private String domainId;
    @SerializedName(value="ispublic")
    private boolean isPublic;

    public static Builder builder() {
        return new Builder();
    }

    public TemplatePermission(String id, String account, String domainId, boolean isPublic) {
        this.id = id;
        this.account = account;
        this.domainId = domainId;
        this.isPublic = isPublic;
    }

    TemplatePermission() {
    }

    public String getId() {
        return this.id;
    }

    public String getAccount() {
        return this.account;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplatePermission that = (TemplatePermission)o;
        if (!Objects.equal((Object)this.domainId, (Object)that.domainId)) {
            return false;
        }
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.isPublic, (Object)that.isPublic)) {
            return false;
        }
        return Objects.equal((Object)this.account, (Object)that.account);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.domainId, this.id, this.isPublic, this.account});
    }

    public String toString() {
        return "TemplatePermission{id=" + this.id + ", account='" + this.account + '\'' + ", domainId=" + this.domainId + ", isPublic=" + this.isPublic + '}';
    }

    @Override
    public int compareTo(TemplatePermission other) {
        return this.id.compareTo(other.getId());
    }

    public static class Builder {
        private String id;
        private String account;
        private String domainId;
        private boolean isPublic;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder isPublic(boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        public TemplatePermission build() {
            return new TemplatePermission(this.id, this.account, this.domainId, this.isPublic);
        }
    }
}

