/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.FirewallRule;
import org.jclouds.cloudstack.domain.PortForwardingRule;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.CreateFirewallRuleOptions;
import org.jclouds.cloudstack.options.ListFirewallRulesOptions;
import org.jclouds.cloudstack.options.ListPortForwardingRulesOptions;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Unwrap;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface FirewallAsyncClient {
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listFirewallRules", "true"})
    @SelectJson(value="firewallrule")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<FirewallRule>> listFirewallRules(ListFirewallRulesOptions ... var1);

    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listFirewallRules", "true"})
    @SelectJson(value="firewallrule")
    @OnlyElement
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<FirewallRule> getFirewallRule(@QueryParam(value="id") String var1);

    @GET
    @QueryParams(keys={"command"}, values={"createFirewallRule"})
    @Unwrap
    @Consumes(value={"application/json"})
    public ListenableFuture<AsyncCreateResponse> createFirewallRuleForIpAndProtocol(@QueryParam(value="ipaddressid") String var1, @QueryParam(value="protocol") FirewallRule.Protocol var2, CreateFirewallRuleOptions ... var3);

    @GET
    @QueryParams(keys={"command"}, values={"deleteFirewallRule"})
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteFirewallRule(@QueryParam(value="id") String var1);

    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listPortForwardingRules", "true"})
    @SelectJson(value="portforwardingrule")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<PortForwardingRule>> listPortForwardingRules(ListPortForwardingRulesOptions ... var1);

    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listPortForwardingRules", "true"})
    @SelectJson(value="portforwardingrule")
    @OnlyElement
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<PortForwardingRule> getPortForwardingRule(@QueryParam(value="id") String var1);

    @GET
    @QueryParams(keys={"command"}, values={"createPortForwardingRule"})
    @Unwrap
    @Consumes(value={"application/json"})
    public ListenableFuture<AsyncCreateResponse> createPortForwardingRuleForVirtualMachine(@QueryParam(value="ipaddressid") String var1, @QueryParam(value="protocol") PortForwardingRule.Protocol var2, @QueryParam(value="publicport") int var3, @QueryParam(value="virtualmachineid") String var4, @QueryParam(value="privateport") int var5);

    @GET
    @QueryParams(keys={"command"}, values={"deletePortForwardingRule"})
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deletePortForwardingRule(@QueryParam(value="id") String var1);
}

