/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.binders;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindCIDRsToCommaDelimitedQueryParam
implements Binder {
    private final Provider<UriBuilder> uriBuilderProvider;

    @Inject
    public BindCIDRsToCommaDelimitedQueryParam(Provider<UriBuilder> uriBuilderProvider) {
        this.uriBuilderProvider = (Provider)Preconditions.checkNotNull(uriBuilderProvider, (Object)"uriBuilderProvider");
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(input instanceof Iterable), (Object)"this binder is only valid for Iterables!");
        Iterable cidrs = (Iterable)Preconditions.checkNotNull((Object)input, (Object)"cidr list");
        Preconditions.checkArgument((Iterables.size((Iterable)cidrs) > 0 ? 1 : 0) != 0, (Object)"you must specify at least one cidr range");
        return (R)ModifyRequest.addQueryParam(request, (String)"cidrlist", (Object)Joiner.on((char)',').join(cidrs), (UriBuilder)((UriBuilder)this.uriBuilderProvider.get()));
    }
}

