/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;

public class AsyncJobError {
    @SerializedName(value="errorcode")
    private ErrorCode errorCode;
    @SerializedName(value="errortext")
    private String errorText;

    AsyncJobError() {
    }

    public AsyncJobError(ErrorCode errorCode, String errorText) {
        this.errorCode = errorCode;
        this.errorText = errorText;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.errorCode, this.errorText});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AsyncJobError that = (AsyncJobError)obj;
        if (!Objects.equal((Object)((Object)this.errorCode), (Object)((Object)that.errorCode))) {
            return false;
        }
        return Objects.equal((Object)this.errorText, (Object)that.errorText);
    }

    public String toString() {
        return "AsyncJobError{errorCode=" + (Object)((Object)this.errorCode) + ", errorText='" + this.errorText + '\'' + '}';
    }

    public static enum ErrorCode {
        INTERNAL_ERROR(530),
        ACCOUNT_ERROR(531),
        ACCOUNT_RESOURCE_LIMIT_ERROR(532),
        INSUFFICIENT_CAPACITY_ERROR(533),
        RESOURCE_UNAVAILABLE_ERROR(534),
        RESOURCE_ALLOCATION_ERROR(535),
        RESOURCE_IN_USE_ERROR(536),
        NETWORK_RULE_CONFLICT_ERROR(537),
        UNKNOWN(-1);

        private final int code;

        private ErrorCode(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }

        public static ErrorCode fromValue(String value) {
            try {
                int errorCode = Integer.parseInt(value);
                for (ErrorCode candidate : ErrorCode.values()) {
                    if (candidate.code() != errorCode) continue;
                    return candidate;
                }
                return UNKNOWN;
            }
            catch (NumberFormatException e) {
                return UNKNOWN;
            }
        }
    }
}

