/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.SerializedName;
import java.util.Set;

public class FirewallRule
implements Comparable<FirewallRule> {
    private String id;
    @SerializedName(value="cidrlist")
    private Set<String> CIDRs;
    @SerializedName(value="startport")
    private int startPort;
    @SerializedName(value="endport")
    private int endPort;
    @SerializedName(value="icmpcode")
    private String icmpCode;
    @SerializedName(value="icmptype")
    private String icmpType;
    @SerializedName(value="ipaddress")
    private String ipAddress;
    @SerializedName(value="ipaddressid")
    private String ipAddressId;
    private Protocol protocol;
    private State state;

    public static Builder builder() {
        return new Builder();
    }

    public FirewallRule(String id, Set<String> CIDRs, int startPort, int endPort, String icmpCode, String icmpType, String ipAddress, String ipAddressId, Protocol protocol, State state) {
        this.id = id;
        this.CIDRs = ImmutableSet.copyOf(CIDRs);
        this.startPort = startPort;
        this.endPort = endPort;
        this.icmpCode = icmpCode;
        this.icmpType = icmpType;
        this.ipAddress = ipAddress;
        this.ipAddressId = ipAddressId;
        this.protocol = protocol;
        this.state = state;
    }

    @Override
    public int compareTo(FirewallRule arg0) {
        return this.id.compareTo(arg0.getId());
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getCIDRs() {
        return this.CIDRs;
    }

    public int getStartPort() {
        return this.startPort;
    }

    public int getEndPort() {
        return this.endPort;
    }

    public String getIcmpCode() {
        return this.icmpCode;
    }

    public String getIcmpType() {
        return this.icmpType;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getIpAddressId() {
        return this.ipAddressId;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public State getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FirewallRule that = (FirewallRule)o;
        if (!Objects.equal((Object)this.endPort, (Object)that.endPort)) {
            return false;
        }
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.startPort, (Object)that.startPort)) {
            return false;
        }
        if (!Objects.equal(this.CIDRs, that.CIDRs)) {
            return false;
        }
        if (!Objects.equal((Object)this.icmpCode, (Object)that.icmpCode)) {
            return false;
        }
        if (!Objects.equal((Object)this.icmpType, (Object)that.icmpType)) {
            return false;
        }
        if (!Objects.equal((Object)this.ipAddress, (Object)that.ipAddress)) {
            return false;
        }
        if (!Objects.equal((Object)this.ipAddressId, (Object)that.ipAddressId)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.protocol), (Object)((Object)that.protocol))) {
            return false;
        }
        return Objects.equal((Object)((Object)this.state), (Object)((Object)that.state));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.endPort, this.id, this.startPort, this.CIDRs, this.icmpCode, this.icmpType, this.ipAddress, this.ipAddressId, this.protocol, this.state});
    }

    public String toString() {
        return "FirewallRule{id=" + this.id + ", CIDRs='" + this.CIDRs + '\'' + ", startPort=" + this.startPort + ", endPort=" + this.endPort + ", icmpCode='" + this.icmpCode + '\'' + ", icmpType='" + this.icmpType + '\'' + ", ipAddress='" + this.ipAddress + '\'' + ", ipAddressId='" + this.ipAddressId + '\'' + ", protocol='" + (Object)((Object)this.protocol) + '\'' + ", state='" + (Object)((Object)this.state) + '\'' + '}';
    }

    public static class Builder {
        private String id;
        private Set<String> CIDRs;
        private int startPort;
        private int endPort;
        private String icmpCode;
        private String icmpType;
        private String ipAddress;
        private String ipAddressId;
        private Protocol protocol;
        private State state;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder CIDRs(Set<String> CIDRs) {
            this.CIDRs = ImmutableSet.copyOf(CIDRs);
            return this;
        }

        public Builder startPort(int startPort) {
            this.startPort = startPort;
            return this;
        }

        public Builder endPort(int endPort) {
            this.endPort = endPort;
            return this;
        }

        public Builder icmpCode(String icmpCode) {
            this.icmpCode = icmpCode;
            return this;
        }

        public Builder icmpType(String icmpType) {
            this.icmpType = icmpType;
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder ipAddressId(String ipAddressId) {
            this.ipAddressId = ipAddressId;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public FirewallRule build() {
            return new FirewallRule(this.id, this.CIDRs, this.startPort, this.endPort, this.icmpCode, this.icmpType, this.ipAddress, this.ipAddressId, this.protocol, this.state);
        }
    }

    public static enum State {
        STAGED,
        ADD,
        ACTIVE,
        DELETING,
        UNKNOWN;


        public static State fromValue(String value) {
            try {
                return State.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }

    public static enum Protocol {
        TCP,
        UDP,
        ICMP,
        UNKNOWN;


        public static Protocol fromValue(String value) {
            try {
                return Protocol.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public String toString() {
            return this.name().toUpperCase();
        }
    }
}

