/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;
import org.jclouds.cloudstack.domain.Account;

public class LoginResponse
implements Comparable<LoginResponse> {
    private final String username;
    @SerializedName(value="userid")
    private final String userId;
    private final String password;
    @SerializedName(value="domainid")
    private final String domainId;
    private final long timeout;
    private final boolean registered;
    @SerializedName(value="account")
    private final String accountName;
    @SerializedName(value="firstname")
    private final String firstName;
    @SerializedName(value="lastname")
    private final String lastName;
    @SerializedName(value="type")
    private final Account.Type accountType;
    private final String timezone;
    @SerializedName(value="timezoneoffset")
    private final String timezoneOffset;
    @SerializedName(value="sessionkey")
    private final String sessionKey;
    private final String jSessionId;

    public static Builder builder() {
        return new Builder();
    }

    public LoginResponse(String username, String userId, String password, String domainId, long timeout, boolean registered, String accountName, String firstName, String lastName, Account.Type accountType, String timezone, String timezoneOffset, String sessionKey, String jSessionId) {
        this.username = username;
        this.userId = userId;
        this.password = password;
        this.domainId = domainId;
        this.timeout = timeout;
        this.registered = registered;
        this.accountName = accountName;
        this.firstName = firstName;
        this.lastName = lastName;
        this.accountType = accountType;
        this.timezone = timezone;
        this.timezoneOffset = timezoneOffset;
        this.sessionKey = sessionKey;
        this.jSessionId = jSessionId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public Account.Type getAccountType() {
        return this.accountType;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public String getTimezoneOffset() {
        return this.timezoneOffset;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public String getJSessionId() {
        return this.jSessionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoginResponse that = (LoginResponse)o;
        if (!Objects.equal((Object)this.accountName, (Object)that.accountName)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.accountType), (Object)((Object)that.accountType))) {
            return false;
        }
        if (!Objects.equal((Object)this.domainId, (Object)that.domainId)) {
            return false;
        }
        if (!Objects.equal((Object)this.firstName, (Object)that.firstName)) {
            return false;
        }
        if (!Objects.equal((Object)this.jSessionId, (Object)that.jSessionId)) {
            return false;
        }
        if (!Objects.equal((Object)this.lastName, (Object)that.lastName)) {
            return false;
        }
        if (!Objects.equal((Object)this.password, (Object)that.password)) {
            return false;
        }
        if (!Objects.equal((Object)this.registered, (Object)that.registered)) {
            return false;
        }
        if (!Objects.equal((Object)this.sessionKey, (Object)that.sessionKey)) {
            return false;
        }
        if (!Objects.equal((Object)this.timeout, (Object)that.timeout)) {
            return false;
        }
        if (!Objects.equal((Object)this.timezone, (Object)that.timezone)) {
            return false;
        }
        if (!Objects.equal((Object)this.timezoneOffset, (Object)that.timezoneOffset)) {
            return false;
        }
        if (!Objects.equal((Object)this.userId, (Object)that.userId)) {
            return false;
        }
        return Objects.equal((Object)this.username, (Object)that.username);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.accountName, this.accountType, this.domainId, this.firstName, this.jSessionId, this.lastName, this.password, this.registered, this.sessionKey, this.timeout, this.timezone, this.timezoneOffset, this.userId, this.username});
    }

    public String toString() {
        return "LoginResponse{username='" + this.username + '\'' + ", userId=" + this.userId + ", password='" + this.password + '\'' + ", domainId=" + this.domainId + ", timeout=" + this.timeout + ", registered=" + this.registered + ", accountName='" + this.accountName + '\'' + ", firstName='" + this.firstName + '\'' + ", lastName='" + this.lastName + '\'' + ", accountType=" + (Object)((Object)this.accountType) + ", timezone='" + this.timezone + '\'' + ", timezoneOffset='" + this.timezoneOffset + '\'' + ", sessionKey='" + this.sessionKey + '\'' + ", jSessionId='" + this.jSessionId + '\'' + '}';
    }

    @Override
    public int compareTo(LoginResponse arg0) {
        return this.sessionKey.compareTo(arg0.getSessionKey());
    }

    public static class Builder {
        private String username;
        private String userId;
        private String password;
        private String domainId;
        private long timeout;
        private boolean registered;
        private String accountName;
        private String firstName;
        private String lastName;
        private Account.Type accountType;
        private String timezone;
        private String timezoneOffset;
        private String sessionKey;
        private String jSessionId;

        public Builder copyOf(LoginResponse r) {
            this.username = r.username;
            this.userId = r.userId;
            this.password = r.password;
            this.domainId = r.domainId;
            this.timeout = r.timeout;
            this.registered = r.registered;
            this.accountName = r.accountName;
            this.firstName = r.firstName;
            this.lastName = r.lastName;
            this.accountType = r.accountType;
            this.timezone = r.timezone;
            this.timezoneOffset = r.timezoneOffset;
            this.sessionKey = r.sessionKey;
            this.jSessionId = r.jSessionId;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder timeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder registered(boolean registered) {
            this.registered = registered;
            return this;
        }

        public Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder accountType(Account.Type accountType) {
            this.accountType = accountType;
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder timezoneOffset(String timezoneOffset) {
            this.timezoneOffset = timezoneOffset;
            return this;
        }

        public Builder sessionKey(String sessionKey) {
            this.sessionKey = sessionKey;
            return this;
        }

        public Builder jSessionId(String jSessionId) {
            this.jSessionId = jSessionId;
            return this;
        }

        public LoginResponse build() {
            return new LoginResponse(this.username, this.userId, this.password, this.domainId, this.timeout, this.registered, this.accountName, this.firstName, this.lastName, this.accountType, this.timezone, this.timezoneOffset, this.sessionKey, this.jSessionId);
        }
    }
}

