/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import javax.annotation.Nullable;

public class PublicIPAddress
implements Comparable<PublicIPAddress> {
    private String id;
    private String account;
    private Date allocated;
    @SerializedName(value="associatednetworkid")
    private String associatedNetworkId;
    private String domain;
    @SerializedName(value="domainid")
    private String domainId;
    @SerializedName(value="forvirtualnetwork")
    private boolean usesVirtualNetwork;
    @SerializedName(value="ipaddress")
    private String IPAddress;
    @SerializedName(value="issourcenat")
    private boolean isSourceNAT;
    @SerializedName(value="isstaticnat")
    private boolean isStaticNAT;
    @SerializedName(value="networkid")
    private String networkId;
    private State state;
    @SerializedName(value="virtualmachinedisplayname")
    private String virtualMachineDisplayName;
    @SerializedName(value="virtualmachineid")
    private String virtualMachineId;
    @SerializedName(value="virtualmachinename")
    private String virtualMachineName;
    @SerializedName(value="VLANid")
    private String VLANId;
    @SerializedName(value="VLANname")
    private String VLANName;
    @SerializedName(value="zoneid")
    private String zoneId;
    @SerializedName(value="zonename")
    private String zoneName;
    @SerializedName(value="jobid")
    @Nullable
    private String jobId;
    @SerializedName(value="jobstatus")
    @Nullable
    private Integer jobStatus;

    public static Builder builder() {
        return new Builder();
    }

    PublicIPAddress() {
    }

    public PublicIPAddress(String id, String account, Date allocated, String associatedNetworkId, String domain, String domainId, boolean usesVirtualNetwork, String iPAddress, boolean isSourceNAT, boolean isStaticNAT, String networkId, State state, String virtualMachineDisplayName, String virtualMachineId, String virtualMachineName, String VLANId, String VLANName, String zoneId, String zoneName, String jobId, Integer jobStatus) {
        this.id = id;
        this.account = account;
        this.allocated = allocated;
        this.associatedNetworkId = associatedNetworkId;
        this.domain = domain;
        this.domainId = domainId;
        this.usesVirtualNetwork = usesVirtualNetwork;
        this.IPAddress = iPAddress;
        this.isSourceNAT = isSourceNAT;
        this.isStaticNAT = isStaticNAT;
        this.networkId = networkId;
        this.state = state;
        this.virtualMachineDisplayName = virtualMachineDisplayName;
        this.virtualMachineId = virtualMachineId;
        this.virtualMachineName = virtualMachineName;
        this.VLANId = VLANId;
        this.VLANName = VLANName;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
        this.jobId = jobId;
        this.jobStatus = jobStatus;
    }

    @Override
    public int compareTo(PublicIPAddress arg0) {
        return this.id.compareTo(arg0.getId());
    }

    public String getId() {
        return this.id;
    }

    public String getAccount() {
        return this.account;
    }

    public Date getAllocated() {
        return this.allocated;
    }

    @Nullable
    public String getJobId() {
        return this.jobId;
    }

    @Nullable
    public Integer getJobStatus() {
        return this.jobStatus;
    }

    public String getAssociatedNetworkId() {
        return this.associatedNetworkId;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public boolean usesVirtualNetwork() {
        return this.usesVirtualNetwork;
    }

    public String getIPAddress() {
        return this.IPAddress;
    }

    public boolean isSourceNAT() {
        return this.isSourceNAT;
    }

    public boolean isStaticNAT() {
        return this.isStaticNAT;
    }

    public String getNetworkId() {
        return this.networkId;
    }

    public State getState() {
        return this.state;
    }

    public String getVirtualMachineDisplayName() {
        return this.virtualMachineDisplayName;
    }

    public String getVirtualMachineId() {
        return this.virtualMachineId;
    }

    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    public String getVLANId() {
        return this.VLANId;
    }

    public String getVLANName() {
        return this.VLANName;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicIPAddress that = (PublicIPAddress)o;
        if (!Objects.equal((Object)this.IPAddress, (Object)that.IPAddress)) {
            return false;
        }
        if (!Objects.equal((Object)this.VLANId, (Object)that.VLANId)) {
            return false;
        }
        if (!Objects.equal((Object)this.VLANName, (Object)that.VLANName)) {
            return false;
        }
        if (!Objects.equal((Object)this.account, (Object)that.account)) {
            return false;
        }
        if (!Objects.equal((Object)this.allocated, (Object)that.allocated)) {
            return false;
        }
        if (!Objects.equal((Object)this.associatedNetworkId, (Object)that.associatedNetworkId)) {
            return false;
        }
        if (!Objects.equal((Object)this.domain, (Object)that.domain)) {
            return false;
        }
        if (!Objects.equal((Object)this.domainId, (Object)that.domainId)) {
            return false;
        }
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.isSourceNAT, (Object)that.isSourceNAT)) {
            return false;
        }
        if (!Objects.equal((Object)this.isStaticNAT, (Object)that.isStaticNAT)) {
            return false;
        }
        if (!Objects.equal((Object)this.networkId, (Object)that.networkId)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.state), (Object)((Object)that.state))) {
            return false;
        }
        if (!Objects.equal((Object)this.usesVirtualNetwork, (Object)that.usesVirtualNetwork)) {
            return false;
        }
        if (!Objects.equal((Object)this.virtualMachineDisplayName, (Object)that.virtualMachineDisplayName)) {
            return false;
        }
        if (!Objects.equal((Object)this.virtualMachineId, (Object)that.virtualMachineId)) {
            return false;
        }
        if (!Objects.equal((Object)this.virtualMachineName, (Object)that.virtualMachineName)) {
            return false;
        }
        if (!Objects.equal((Object)this.zoneId, (Object)that.zoneId)) {
            return false;
        }
        if (!Objects.equal((Object)this.zoneName, (Object)that.zoneName)) {
            return false;
        }
        return Objects.equal((Object)this.jobStatus, (Object)that.jobStatus);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.IPAddress, this.VLANId, this.VLANName, this.account, this.allocated, this.associatedNetworkId, this.domain, this.domainId, this.id, this.isSourceNAT, this.isStaticNAT, this.networkId, this.state, this.usesVirtualNetwork, this.virtualMachineDisplayName, this.virtualMachineId, this.virtualMachineName, this.zoneId, this.zoneName, this.jobStatus});
    }

    public String toString() {
        return "PublicIPAddress{id=" + this.id + ", account='" + this.account + '\'' + ", allocated=" + this.allocated + ", associatedNetworkId=" + this.associatedNetworkId + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", usesVirtualNetwork=" + this.usesVirtualNetwork + ", IPAddress='" + this.IPAddress + '\'' + ", isSourceNAT=" + this.isSourceNAT + ", isStaticNAT=" + this.isStaticNAT + ", networkId=" + this.networkId + ", state=" + (Object)((Object)this.state) + ", virtualMachineDisplayName='" + this.virtualMachineDisplayName + '\'' + ", virtualMachineId=" + this.virtualMachineId + ", virtualMachineName='" + this.virtualMachineName + '\'' + ", VLANId=" + this.VLANId + ", VLANName='" + this.VLANName + '\'' + ", zoneId=" + this.zoneId + ", zoneName='" + this.zoneName + '\'' + ", jobId=" + this.jobId + ", jobStatus=" + this.jobStatus + '}';
    }

    public static enum State {
        ALLOCATING,
        ALLOCATED,
        RELEASING,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)state, (Object)"state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static class Builder {
        private String id;
        private String account;
        private Date allocated;
        private String associatedNetworkId;
        private String domain;
        private String domainId;
        private boolean usesVirtualNetwork;
        private String IPAddress;
        private boolean isSourceNAT;
        private boolean isStaticNAT;
        private String networkId;
        private State state;
        private String virtualMachineDisplayName;
        private String virtualMachineId;
        private String virtualMachineName;
        private String VLANId;
        private String VLANName;
        private String zoneId;
        private String zoneName;
        private String jobId;
        private Integer jobStatus;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder allocated(Date allocated) {
            this.allocated = allocated;
            return this;
        }

        public Builder associatedNetworkId(String associatedNetworkId) {
            this.associatedNetworkId = associatedNetworkId;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder usesVirtualNetwork(boolean usesVirtualNetwork) {
            this.usesVirtualNetwork = usesVirtualNetwork;
            return this;
        }

        public Builder IPAddress(String IPAddress) {
            this.IPAddress = IPAddress;
            return this;
        }

        public Builder isSourceNAT(boolean isSourceNAT) {
            this.isSourceNAT = isSourceNAT;
            return this;
        }

        public Builder isStaticNAT(boolean isStaticNAT) {
            this.isStaticNAT = isStaticNAT;
            return this;
        }

        public Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder virtualMachineDisplayName(String virtualMachineDisplayName) {
            this.virtualMachineDisplayName = virtualMachineDisplayName;
            return this;
        }

        public Builder virtualMachineId(String virtualMachineId) {
            this.virtualMachineId = virtualMachineId;
            return this;
        }

        public Builder virtualMachineName(String virtualMachineName) {
            this.virtualMachineName = virtualMachineName;
            return this;
        }

        public Builder VLANId(String VLANId) {
            this.VLANId = VLANId;
            return this;
        }

        public Builder VLANName(String VLANName) {
            this.VLANName = VLANName;
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobStatus(int jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        public PublicIPAddress build() {
            return new PublicIPAddress(this.id, this.account, this.allocated, this.associatedNetworkId, this.domain, this.domainId, this.usesVirtualNetwork, this.IPAddress, this.isSourceNAT, this.isStaticNAT, this.networkId, this.state, this.virtualMachineDisplayName, this.virtualMachineId, this.virtualMachineName, this.VLANId, this.VLANName, this.zoneId, this.zoneName, this.jobId, this.jobStatus);
        }
    }
}

