/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class ResourceLimit
implements Comparable<ResourceLimit> {
    private String account;
    private String domain;
    @SerializedName(value="domainid")
    private String domainId;
    private int max;
    @SerializedName(value="resourcetype")
    private ResourceType resourceType;

    public static Builder builder() {
        return new Builder();
    }

    ResourceLimit() {
    }

    public ResourceLimit(String account, String domain, String domainId, int max, ResourceType resourceType) {
        this.account = account;
        this.domain = domain;
        this.domainId = domainId;
        this.max = max;
        this.resourceType = resourceType;
    }

    public String getAccount() {
        return this.account;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public int getMax() {
        return this.max;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceLimit that = (ResourceLimit)o;
        if (!Objects.equal((Object)this.domainId, (Object)that.domainId)) {
            return false;
        }
        if (!Objects.equal((Object)this.max, (Object)that.max)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.resourceType), (Object)((Object)that.resourceType))) {
            return false;
        }
        if (!Objects.equal((Object)this.account, (Object)that.account)) {
            return false;
        }
        return Objects.equal((Object)this.domain, (Object)that.domain);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.domainId, this.max, this.resourceType, this.account, this.domain});
    }

    @Override
    public int compareTo(ResourceLimit that) {
        return this.account.compareTo(that.account);
    }

    public String toString() {
        return "ResourceLimit{account='" + this.account + '\'' + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", max=" + this.max + ", resourceType=" + (Object)((Object)this.resourceType) + '}';
    }

    public static enum ResourceType {
        INSTANCE(0),
        IP(1),
        VOLUME(2),
        SNAPSHOT(3),
        TEMPLATE(4),
        UNRECOGNIZED(Integer.MAX_VALUE);

        private int code;
        private static final Map<Integer, ResourceType> INDEX;

        private ResourceType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public String toString() {
            return this.name();
        }

        public static ResourceType fromValue(String resourceType) {
            Integer code = new Integer((String)Preconditions.checkNotNull((Object)resourceType, (Object)"resourcetype"));
            return INDEX.containsKey(code) ? INDEX.get(code) : UNRECOGNIZED;
        }

        static {
            INDEX = Maps.uniqueIndex((Iterable)ImmutableSet.copyOf((Object[])ResourceType.values()), (Function)new Function<ResourceType, Integer>(){

                public Integer apply(ResourceType input) {
                    return input.code;
                }
            });
        }
    }

    public static class Builder {
        private String account;
        private String domain;
        private String domainId;
        private int max;
        private ResourceType resourceType;

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder max(int max) {
            this.max = max;
            return this;
        }

        public Builder resourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public ResourceLimit build() {
            return new ResourceLimit(this.account, this.domain, this.domainId, this.max, this.resourceType);
        }
    }
}

