/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;

public class SshKeyPair
implements Comparable<SshKeyPair> {
    private String fingerprint;
    private String name;
    @SerializedName(value="privatekey")
    private String privateKey;

    public static Builder builder() {
        return new Builder();
    }

    SshKeyPair() {
    }

    public SshKeyPair(String fingerprint, String name, String privateKey) {
        this.fingerprint = fingerprint;
        this.name = name;
        this.privateKey = privateKey;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getName() {
        return this.name;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SshKeyPair that = (SshKeyPair)o;
        if (!Objects.equal((Object)this.fingerprint, (Object)that.fingerprint)) {
            return false;
        }
        if (!Objects.equal((Object)this.name, (Object)that.name)) {
            return false;
        }
        return Objects.equal((Object)this.privateKey, (Object)that.privateKey);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fingerprint, this.name, this.privateKey});
    }

    public String toString() {
        return "SshKeyPair{fingerprint='" + this.fingerprint + '\'' + ", name='" + this.name + '\'' + ", privateKey='" + this.privateKey + '\'' + '}';
    }

    @Override
    public int compareTo(SshKeyPair arg0) {
        return this.fingerprint.compareTo(arg0.getFingerprint());
    }

    public static class Builder {
        private String fingerprint;
        private String name;
        private String privateKey;

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public SshKeyPair build() {
            return new SshKeyPair(this.fingerprint, this.name, this.privateKey);
        }
    }
}

