/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.util.Date;

public class StoragePool
implements Comparable<StoragePool> {
    private String id;
    private String name;
    private String path;
    private String tags;
    private State state;
    private Type type;
    @SerializedName(value="zoneid")
    private String zoneId;
    @SerializedName(value="zonename")
    private String zoneName;
    @SerializedName(value="podid")
    private String podId;
    @SerializedName(value="podname")
    private String podName;
    @SerializedName(value="clusterid")
    private String clusterId;
    @SerializedName(value="clustername")
    private String clusterName;
    private Date created;
    @SerializedName(value="disksizeallocated")
    private long diskSizeAllocated;
    @SerializedName(value="disksizetotal")
    private long diskSizeTotal;
    @SerializedName(value="ipaddress")
    private String ipAddress;
    @SerializedName(value="jobid")
    private String jobId;
    @SerializedName(value="jobstatus")
    private String jobStatus;

    public static Builder builder() {
        return new Builder();
    }

    StoragePool() {
    }

    public StoragePool(String id, String name, String path, String tags, State state, Type type, String zoneId, String zoneName, String podId, String podName, String clusterId, String clusterName, Date created, long diskSizeAllocated, long diskSizeTotal, String ipAddress, String jobId, String jobStatus) {
        this.id = id;
        this.name = name;
        this.path = path;
        this.tags = tags;
        this.state = state;
        this.type = type;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
        this.podId = podId;
        this.podName = podName;
        this.clusterId = clusterId;
        this.clusterName = clusterName;
        this.created = created;
        this.diskSizeAllocated = diskSizeAllocated;
        this.diskSizeTotal = diskSizeTotal;
        this.ipAddress = ipAddress;
        this.jobId = jobId;
        this.jobStatus = jobStatus;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getTags() {
        return this.tags;
    }

    public State getState() {
        return this.state;
    }

    public Type getType() {
        return this.type;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public String getPodId() {
        return this.podId;
    }

    public String getPodName() {
        return this.podName;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Date getCreated() {
        return this.created;
    }

    public long getDiskSizeAllocated() {
        return this.diskSizeAllocated;
    }

    public long getDiskSizeTotal() {
        return this.diskSizeTotal;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoragePool that = (StoragePool)o;
        if (!Objects.equal((Object)this.clusterId, (Object)that.clusterId)) {
            return false;
        }
        if (!Objects.equal((Object)this.diskSizeAllocated, (Object)that.diskSizeAllocated)) {
            return false;
        }
        if (!Objects.equal((Object)this.diskSizeTotal, (Object)that.diskSizeTotal)) {
            return false;
        }
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.podId, (Object)that.podId)) {
            return false;
        }
        if (!Objects.equal((Object)this.zoneId, (Object)that.zoneId)) {
            return false;
        }
        if (!Objects.equal((Object)this.clusterName, (Object)that.clusterName)) {
            return false;
        }
        if (!Objects.equal((Object)this.created, (Object)that.created)) {
            return false;
        }
        if (!Objects.equal((Object)this.ipAddress, (Object)that.ipAddress)) {
            return false;
        }
        if (!Objects.equal((Object)this.jobId, (Object)that.jobId)) {
            return false;
        }
        if (!Objects.equal((Object)this.jobStatus, (Object)that.jobStatus)) {
            return false;
        }
        if (!Objects.equal((Object)this.name, (Object)that.name)) {
            return false;
        }
        if (!Objects.equal((Object)this.path, (Object)that.path)) {
            return false;
        }
        if (!Objects.equal((Object)this.podName, (Object)that.podName)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.state), (Object)((Object)that.state))) {
            return false;
        }
        if (!Objects.equal((Object)this.tags, (Object)that.tags)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.type), (Object)((Object)that.type))) {
            return false;
        }
        return Objects.equal((Object)this.zoneName, (Object)that.zoneName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.clusterId, this.diskSizeAllocated, this.diskSizeTotal, this.id, this.podId, this.zoneId, this.clusterName, this.created, this.ipAddress, this.jobId, this.jobStatus, this.name, this.path, this.podName, this.state, this.tags, this.type, this.zoneName});
    }

    public String toString() {
        return "StoragePool{id=" + this.id + ", name='" + this.name + '\'' + ", path='" + this.path + '\'' + ", tags='" + this.tags + '\'' + ", state=" + (Object)((Object)this.state) + ", type=" + (Object)((Object)this.type) + ", zoneId=" + this.zoneId + ", zoneName='" + this.zoneName + '\'' + ", podId=" + this.podId + ", podName='" + this.podName + '\'' + ", clusterId=" + this.clusterId + ", clusterName='" + this.clusterName + '\'' + ", created=" + this.created + ", diskSizeAllocated=" + this.diskSizeAllocated + ", diskSizeTotal=" + this.diskSizeTotal + ", ipAddress='" + this.ipAddress + '\'' + ", jobId=" + this.jobId + ", jobStatus='" + this.jobStatus + '\'' + '}';
    }

    @Override
    public int compareTo(StoragePool other) {
        return this.id.compareTo(other.id);
    }

    public static class Builder {
        private String id;
        private String name;
        private String path;
        private String tags;
        private State state;
        private Type type;
        private String zoneId;
        private String zoneName;
        private String podId;
        private String podName;
        private String clusterId;
        private String clusterName;
        private Date created;
        private long diskSizeAllocated;
        private long diskSizeTotal;
        private String ipAddress;
        private String jobId;
        private String jobStatus;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder tags(String tags) {
            this.tags = tags;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Builder podId(String podId) {
            this.podId = podId;
            return this;
        }

        public Builder podName(String podName) {
            this.podName = podName;
            return this;
        }

        public Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder diskSizeAllocated(long diskSizeAllocated) {
            this.diskSizeAllocated = diskSizeAllocated;
            return this;
        }

        public Builder diskSizeTotal(long diskSizeTotal) {
            this.diskSizeTotal = diskSizeTotal;
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        public StoragePool build() {
            return new StoragePool(this.id, this.name, this.path, this.tags, this.state, this.type, this.zoneId, this.zoneName, this.podId, this.podName, this.clusterId, this.clusterName, this.created, this.diskSizeAllocated, this.diskSizeTotal, this.ipAddress, this.jobId, this.jobStatus);
        }
    }

    public static enum Type {
        FILESYSTEM,
        NETWORK_FILESYSTEM,
        ISCSI_LUN,
        ISCSI,
        ISO,
        LVM,
        CLVM,
        SHARED_MOUNT_POINT,
        VMFS,
        PRE_SETUP,
        EXT,
        OCFS2,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static Type fromValue(String type) {
            try {
                return Type.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)type, (Object)"type")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum State {
        UP,
        PREPARE_FOR_MAINTENANCE,
        ERROR_IN_MAINTENANCE,
        CANCEL_MAINTENANCE,
        MAINTENANCE,
        REMOVED,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static State fromValue(String type) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)type, (Object)"type")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

