/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import org.jclouds.cloudstack.domain.ExtractMode;

public class TemplateExtraction
implements Comparable<TemplateExtraction> {
    private String id;
    @SerializedName(value="accountid")
    private String accountId;
    private Date created;
    private String extractId;
    private ExtractMode extractMode;
    private String name;
    private String state;
    private String status;
    @SerializedName(value="storagetype")
    private String storageType;
    @SerializedName(value="uploadpercentage")
    private int uploadPercentage;
    private String url;
    @SerializedName(value="zoneid")
    private String zoneId;
    @SerializedName(value="zonename")
    private String zoneName;

    public static Builder builder() {
        return new Builder();
    }

    public TemplateExtraction(String id, String accountId, Date created, String extractId, ExtractMode extractMode, String name, String state, String status, String storageType, int uploadPercentage, String url, String zoneId, String zoneName) {
        this.id = id;
        this.accountId = accountId;
        this.created = created;
        this.extractId = extractId;
        this.extractMode = extractMode;
        this.name = name;
        this.state = state;
        this.status = status;
        this.storageType = storageType;
        this.uploadPercentage = uploadPercentage;
        this.url = url;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
    }

    TemplateExtraction() {
    }

    public String getId() {
        return this.id;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getExtractId() {
        return this.extractId;
    }

    public ExtractMode getExtractMode() {
        return this.extractMode;
    }

    public String getName() {
        return this.name;
    }

    public String getState() {
        return this.state;
    }

    public String getStatus() {
        return this.status;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public int getUploadPercentage() {
        return this.uploadPercentage;
    }

    public String getUrl() {
        return this.url;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateExtraction that = (TemplateExtraction)o;
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.accountId, (Object)that.accountId)) {
            return false;
        }
        if (!Objects.equal((Object)this.created, (Object)that.created)) {
            return false;
        }
        if (!Objects.equal((Object)this.extractId, (Object)that.extractId)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.extractMode), (Object)((Object)that.extractMode))) {
            return false;
        }
        if (!Objects.equal((Object)this.name, (Object)that.name)) {
            return false;
        }
        if (!Objects.equal((Object)this.state, (Object)that.state)) {
            return false;
        }
        if (!Objects.equal((Object)this.status, (Object)that.status)) {
            return false;
        }
        if (!Objects.equal((Object)this.storageType, (Object)that.storageType)) {
            return false;
        }
        if (!Objects.equal((Object)this.uploadPercentage, (Object)that.uploadPercentage)) {
            return false;
        }
        if (!Objects.equal((Object)this.url, (Object)that.url)) {
            return false;
        }
        if (!Objects.equal((Object)this.zoneId, (Object)that.zoneId)) {
            return false;
        }
        return Objects.equal((Object)this.zoneName, (Object)that.zoneName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.accountId, this.created, this.extractId, this.extractMode, this.name, this.state, this.status, this.storageType, this.uploadPercentage, this.url, this.zoneId, this.zoneName});
    }

    public String toString() {
        return "TemplateExtraction{id=" + this.id + ", accountId=" + this.accountId + ", created=" + this.created + ", extractId=" + this.extractId + ", extractMode=" + (Object)((Object)this.extractMode) + ", name='" + this.name + '\'' + ", state='" + this.state + '\'' + ", status='" + this.status + '\'' + ", storageType='" + this.storageType + '\'' + ", uploadPercentage=" + this.uploadPercentage + ", url='" + this.url + '\'' + ", zoneId=" + this.zoneId + ", zoneName='" + this.zoneName + '\'' + '}';
    }

    @Override
    public int compareTo(TemplateExtraction other) {
        return this.id.compareTo(other.id);
    }

    public static class Builder {
        private String id;
        private String accountId;
        private Date created;
        private String extractId;
        private ExtractMode extractMode;
        private String name;
        private String state;
        private String status;
        private String storageType;
        private int uploadPercentage;
        private String url;
        private String zoneId;
        private String zoneName;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder extractId(String extractId) {
            this.extractId = extractId;
            return this;
        }

        public Builder extractMode(ExtractMode extractMode) {
            this.extractMode = extractMode;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public Builder uploadPercentage(int uploadPercentage) {
            this.uploadPercentage = uploadPercentage;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public TemplateExtraction build() {
            return new TemplateExtraction(this.id, this.accountId, this.created, this.extractId, this.extractMode, this.name, this.state, this.status, this.storageType, this.uploadPercentage, this.url, this.zoneId, this.zoneName);
        }
    }
}

