/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;
import java.util.Date;

public class VMGroup
implements Comparable<VMGroup> {
    private String id;
    private String account;
    private Date created;
    private String domain;
    @SerializedName(value="domainid")
    private String domainId;
    private String name;

    public static Builder builder() {
        return new Builder();
    }

    public VMGroup(String id, String account, Date created, String domain, String domainId, String name) {
        this.id = id;
        this.account = account;
        this.created = created;
        this.domain = domain;
        this.domainId = domainId;
        this.name = name;
    }

    VMGroup() {
    }

    public String getId() {
        return this.id;
    }

    public String getAccount() {
        return this.account;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VMGroup that = (VMGroup)o;
        if (!Objects.equal((Object)this.domainId, (Object)that.domainId)) {
            return false;
        }
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.account, (Object)that.account)) {
            return false;
        }
        if (!Objects.equal((Object)this.created, (Object)that.created)) {
            return false;
        }
        if (!Objects.equal((Object)this.domain, (Object)that.domain)) {
            return false;
        }
        return Objects.equal((Object)this.name, (Object)that.name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.domainId, this.id, this.account, this.created, this.domain, this.name});
    }

    public String toString() {
        return "VMGroup{id=" + this.id + ", account='" + this.account + '\'' + ", created=" + this.created + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", name='" + this.name + '\'' + '}';
    }

    @Override
    public int compareTo(VMGroup vmGroup) {
        return this.id.compareTo(vmGroup.getId());
    }

    public static class Builder {
        private String id;
        private String account;
        private Date created;
        private String domain;
        private String domainId;
        private String name;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public VMGroup build() {
            return new VMGroup(this.id, this.account, this.created, this.domain, this.domainId, this.name);
        }
    }
}

