/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class Capacity
implements Comparable<Capacity> {
    @SerializedName(value="capacitytotal")
    private long capacityTotal;
    @SerializedName(value="capacityused")
    private long capacityUsed;
    @SerializedName(value="percentused")
    private double percentUsed;
    @SerializedName(value="podid")
    private String podId;
    @SerializedName(value="podname")
    private String podName;
    private Type type;
    @SerializedName(value="zoneid")
    private String zoneId;
    @SerializedName(value="zonename")
    private String zoneName;

    public static Builder builder() {
        return new Builder();
    }

    Capacity() {
    }

    public Capacity(long capacityTotal, long capacityUsed, double percentUsed, String podId, String podName, Type type, String zoneId, String zoneName) {
        this.capacityTotal = capacityTotal;
        this.capacityUsed = capacityUsed;
        this.percentUsed = percentUsed;
        this.podId = podId;
        this.podName = podName;
        this.type = type;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
    }

    public long getCapacityTotal() {
        return this.capacityTotal;
    }

    public long getCapacityUsed() {
        return this.capacityUsed;
    }

    public double getPercentUsed() {
        return this.percentUsed;
    }

    public String getPodId() {
        return this.podId;
    }

    public String getPodName() {
        return this.podName;
    }

    public Type getType() {
        return this.type;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Capacity that = (Capacity)o;
        if (!Objects.equal((Object)this.capacityTotal, (Object)that.capacityTotal)) {
            return false;
        }
        if (!Objects.equal((Object)this.capacityUsed, (Object)that.capacityUsed)) {
            return false;
        }
        if (!Objects.equal((Object)this.percentUsed, (Object)that.percentUsed)) {
            return false;
        }
        if (!Objects.equal((Object)this.podId, (Object)that.podId)) {
            return false;
        }
        if (!Objects.equal((Object)this.zoneId, (Object)that.zoneId)) {
            return false;
        }
        if (!Objects.equal((Object)this.podName, (Object)that.podName)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.type), (Object)((Object)that.type))) {
            return false;
        }
        return Objects.equal((Object)this.zoneName, (Object)that.zoneName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.capacityTotal, this.capacityUsed, this.percentUsed, this.podId, this.podName, this.type, this.zoneId, this.zoneName});
    }

    public String toString() {
        return "Capacity{capacityTotal=" + this.capacityTotal + ", capacityUsed=" + this.capacityUsed + ", percentUsed=" + this.percentUsed + ", podId=" + this.podId + ", podName='" + this.podName + '\'' + ", type=" + (Object)((Object)this.type) + ", zoneId=" + this.zoneId + ", zoneName='" + this.zoneName + '\'' + '}';
    }

    @Override
    public int compareTo(Capacity other) {
        int comparison = this.zoneId.compareTo(other.zoneId);
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.podId.compareTo(other.podId);
        if (comparison != 0) {
            return comparison;
        }
        return Integer.valueOf(this.type.code).compareTo(other.type.code);
    }

    public static enum Type {
        MEMORY_ALLOCATED_BYTES(0),
        CPU_ALLOCATED_MHZ(1),
        PRIMARY_STORAGE_USED_BYTES(2),
        PRIMARY_STORAGE_ALLOCATED_BYTES(3),
        PUBLIC_IP_ADDRESSES(4),
        PRIVATE_IP_ADDRESSES(5),
        SECONDARY_STORAGE_USED_BYTES(6),
        VLANS(7),
        DIRECT_ATTACHED_PUBLIC_IP_ADDRESSES(8),
        LOCAL_STORAGE_USED_BYTES(9),
        UNRECOGNIZED(Integer.MAX_VALUE);

        private int code;
        private static final Map<Integer, Type> INDEX;

        private Type(int code) {
            this.code = code;
        }

        public String toString() {
            return this.name();
        }

        public static Type fromValue(String type) {
            Integer code = new Integer((String)Preconditions.checkNotNull((Object)type, (Object)"type"));
            return INDEX.containsKey(code) ? INDEX.get(code) : UNRECOGNIZED;
        }

        static {
            INDEX = Maps.uniqueIndex((Iterable)ImmutableSet.copyOf((Object[])Type.values()), (Function)new Function<Type, Integer>(){

                public Integer apply(Type input) {
                    return input.code;
                }
            });
        }
    }

    public static class Builder {
        private long capacityTotal;
        private long capacityUsed;
        private double percentUsed;
        private String podId;
        private String podName;
        private Type type;
        private String zoneId;
        private String zoneName;

        public Builder capacityTotal(long capacityTotal) {
            this.capacityTotal = capacityTotal;
            return this;
        }

        public Builder capacityUsed(long capacityUsed) {
            this.capacityUsed = capacityUsed;
            return this;
        }

        public Builder percentUsed(double percentUsed) {
            this.percentUsed = percentUsed;
            return this;
        }

        public Builder podId(String podId) {
            this.podId = podId;
            return this;
        }

        public Builder podName(String podName) {
            this.podName = podName;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Capacity build() {
            return new Capacity(this.capacityTotal, this.capacityUsed, this.percentUsed, this.podId, this.podName, this.type, this.zoneId, this.zoneName);
        }
    }
}

