/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;

public class Domain
implements Comparable<Domain> {
    private String id;
    @SerializedName(value="haschild")
    private boolean hasChild;
    private long level;
    private String name;
    @SerializedName(value="networkdomain")
    private String networkDomain;
    @SerializedName(value="parentdomainid")
    private String parentDomainId;
    @SerializedName(value="parentdomainname")
    private String parentDomainName;

    public static Builder builder() {
        return new Builder();
    }

    Domain() {
    }

    public Domain(String id, boolean hasChild, long level, String name, String networkDomain, String parentDomainId, String parentDomainName) {
        this.id = id;
        this.hasChild = hasChild;
        this.level = level;
        this.name = name;
        this.networkDomain = networkDomain;
        this.parentDomainId = parentDomainId;
        this.parentDomainName = parentDomainName;
    }

    public String getId() {
        return this.id;
    }

    public boolean hasChild() {
        return this.hasChild;
    }

    public long getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    public String getNetworkDomain() {
        return this.networkDomain;
    }

    public String getParentDomainId() {
        return this.parentDomainId;
    }

    public String getParentDomainName() {
        return this.parentDomainName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Domain that = (Domain)o;
        if (!Objects.equal((Object)this.hasChild, (Object)that.hasChild)) {
            return false;
        }
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.level, (Object)that.level)) {
            return false;
        }
        if (!Objects.equal((Object)this.parentDomainId, (Object)that.parentDomainId)) {
            return false;
        }
        if (!Objects.equal((Object)this.name, (Object)that.name)) {
            return false;
        }
        if (!Objects.equal((Object)this.networkDomain, (Object)that.networkDomain)) {
            return false;
        }
        return Objects.equal((Object)this.parentDomainName, (Object)that.parentDomainName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.hasChild, this.level, this.name, this.networkDomain, this.parentDomainId, this.parentDomainName});
    }

    public String toString() {
        return "Domain{id='" + this.id + '\'' + ", hasChild=" + this.hasChild + ", level=" + this.level + ", name='" + this.name + '\'' + ", networkDomain='" + this.networkDomain + '\'' + ", parentDomainId='" + this.parentDomainId + '\'' + ", parentDomainName='" + this.parentDomainName + '\'' + '}';
    }

    @Override
    public int compareTo(Domain arg0) {
        return this.id.compareTo(arg0.getId());
    }

    public static class Builder {
        private String id;
        private boolean hasChild;
        private long level;
        private String name;
        private String networkDomain;
        private String parentDomainId;
        private String parentDomainName;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder hasChild(boolean hasChild) {
            this.hasChild = hasChild;
            return this;
        }

        public Builder level(long level) {
            this.level = level;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder networkDomain(String networkDomain) {
            this.networkDomain = networkDomain;
            return this;
        }

        public Builder parentDomainId(String parentDomainId) {
            this.parentDomainId = parentDomainId;
            return this;
        }

        public Builder parentDomainName(String parentDomainName) {
            this.parentDomainName = parentDomainName;
            return this;
        }

        public Domain build() {
            return new Domain(this.id, this.hasChild, this.level, this.name, this.networkDomain, this.parentDomainId, this.parentDomainName);
        }
    }
}

