/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import java.util.Date;

public class Event
implements Comparable<Event> {
    private String id;
    private String account;
    private String description;
    private Date created;
    private String domain;
    private String domainId;
    private String level;
    private String parentId;
    private String state;
    private String type;
    private String username;

    public static Builder builder() {
        return new Builder();
    }

    public Event(String id, String account, String description, Date created, String domain, String domainId, String level, String parentId, String state, String type, String username) {
        this.id = id;
        this.account = account;
        this.description = description;
        this.created = created;
        this.domain = domain;
        this.domainId = domainId;
        this.level = level;
        this.parentId = parentId;
        this.state = state;
        this.type = type;
        this.username = username;
    }

    Event() {
    }

    public String getId() {
        return this.id;
    }

    public String getAccount() {
        return this.account;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public String getLevel() {
        return this.level;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getState() {
        return this.state;
    }

    public String getType() {
        return this.type;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public int compareTo(Event arg0) {
        return this.id.compareTo(arg0.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event that = (Event)o;
        if (!Objects.equal((Object)this.domainId, (Object)that.domainId)) {
            return false;
        }
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.account, (Object)that.account)) {
            return false;
        }
        if (!Objects.equal((Object)this.created, (Object)that.created)) {
            return false;
        }
        if (!Objects.equal((Object)this.description, (Object)that.description)) {
            return false;
        }
        if (!Objects.equal((Object)this.domain, (Object)that.domain)) {
            return false;
        }
        if (!Objects.equal((Object)this.level, (Object)that.level)) {
            return false;
        }
        if (!Objects.equal((Object)this.parentId, (Object)that.parentId)) {
            return false;
        }
        if (!Objects.equal((Object)this.state, (Object)that.state)) {
            return false;
        }
        if (!Objects.equal((Object)this.type, (Object)that.type)) {
            return false;
        }
        return Objects.equal((Object)this.username, (Object)that.username);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.account, this.description, this.created, this.domain, this.domainId, this.level, this.parentId, this.state, this.type, this.username});
    }

    public String toString() {
        return "Event{id=" + this.id + ", account='" + this.account + '\'' + ", description='" + this.description + '\'' + ", created=" + this.created + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", level='" + this.level + '\'' + ", parentId='" + this.parentId + '\'' + ", state='" + this.state + '\'' + ", type='" + this.type + '\'' + ", username='" + this.username + '\'' + '}';
    }

    public static class Builder {
        private String id;
        private String account;
        private String description;
        private Date created;
        private String domain;
        private String domainId;
        private String level;
        private String parentId;
        private String state;
        private String type;
        private String username;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder level(String level) {
            this.level = level;
            return this;
        }

        public Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Event build() {
            return new Event(this.id, this.account, this.description, this.created, this.domain, this.domainId, this.level, this.parentId, this.state, this.type, this.username);
        }
    }
}

