/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.SerializedName;
import java.util.Set;

public class LoadBalancerRule
implements Comparable<LoadBalancerRule> {
    private String id;
    private String account;
    private Algorithm algorithm;
    private String description;
    private String domain;
    @SerializedName(value="domainid")
    private String domainId;
    private String name;
    @SerializedName(value="privateport")
    private int privatePort;
    @SerializedName(value="publicip")
    private String publicIP;
    @SerializedName(value="publicipid")
    private String publicIPId;
    @SerializedName(value="publicport")
    private int publicPort;
    private State state;
    @SerializedName(value="cidrlist")
    private Set<String> CIDRs;
    @SerializedName(value="zoneId")
    private String zoneId;

    public static Builder builder() {
        return new Builder();
    }

    LoadBalancerRule() {
    }

    public LoadBalancerRule(String id, String account, Algorithm algorithm, String description, String domain, String domainId, String name, int privatePort, String publicIP, String publicIPId, int publicPort, State state, String zoneId, Set<String> CIDRs) {
        this.id = id;
        this.account = account;
        this.algorithm = algorithm;
        this.description = description;
        this.domain = domain;
        this.domainId = domainId;
        this.name = name;
        this.privatePort = privatePort;
        this.publicIP = publicIP;
        this.publicIPId = publicIPId;
        this.publicPort = publicPort;
        this.state = state;
        this.zoneId = zoneId;
        this.CIDRs = ImmutableSet.copyOf(CIDRs);
    }

    public String getId() {
        return this.id;
    }

    public String getAccount() {
        return this.account;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public String getName() {
        return this.name;
    }

    public int getPrivatePort() {
        return this.privatePort;
    }

    public String getPublicIP() {
        return this.publicIP;
    }

    public String getPublicIPId() {
        return this.publicIPId;
    }

    public int getPublicPort() {
        return this.publicPort;
    }

    public State getState() {
        return this.state;
    }

    public Set<String> getCIDRs() {
        return this.CIDRs;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    @Override
    public int compareTo(LoadBalancerRule arg0) {
        return this.id.compareTo(arg0.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadBalancerRule that = (LoadBalancerRule)o;
        if (!Objects.equal((Object)this.account, (Object)that.account)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.algorithm), (Object)((Object)that.algorithm))) {
            return false;
        }
        if (!Objects.equal((Object)this.description, (Object)that.description)) {
            return false;
        }
        if (!Objects.equal((Object)this.domain, (Object)that.domain)) {
            return false;
        }
        if (!Objects.equal((Object)this.domainId, (Object)that.domainId)) {
            return false;
        }
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.name, (Object)that.name)) {
            return false;
        }
        if (!Objects.equal((Object)this.privatePort, (Object)that.privatePort)) {
            return false;
        }
        if (!Objects.equal((Object)this.publicIP, (Object)that.publicIP)) {
            return false;
        }
        if (!Objects.equal((Object)this.publicIPId, (Object)that.publicIPId)) {
            return false;
        }
        if (!Objects.equal((Object)this.publicPort, (Object)that.publicPort)) {
            return false;
        }
        if (!Objects.equal((Object)this.zoneId, (Object)that.zoneId)) {
            return false;
        }
        return Objects.equal((Object)((Object)this.state), (Object)((Object)that.state));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.account, this.algorithm, this.description, this.domain, this.domainId, this.id, this.name, this.privatePort, this.publicIP, this.publicIPId, this.publicPort, this.zoneId, this.state});
    }

    public String toString() {
        return "LoadBalancerRule{id=" + this.id + ", account='" + this.account + '\'' + ", algorithm=" + (Object)((Object)this.algorithm) + ", description='" + this.description + '\'' + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", name='" + this.name + '\'' + ", privatePort=" + this.privatePort + ", publicIP='" + this.publicIP + '\'' + ", publicIPId=" + this.publicIPId + ", publicPort=" + this.publicPort + ", state=" + (Object)((Object)this.state) + ", CIDRs=" + this.CIDRs + ", zoneId=" + this.zoneId + '}';
    }

    public static class Builder {
        private String id;
        private String account;
        private Algorithm algorithm;
        private String description;
        private String domain;
        private String domainId;
        private String name;
        private int privatePort;
        private String publicIP;
        private String publicIPId;
        private int publicPort;
        private State state;
        private Set<String> CIDRs = ImmutableSet.of();
        private String zoneId;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder algorithm(Algorithm algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder privatePort(int privatePort) {
            this.privatePort = privatePort;
            return this;
        }

        public Builder publicIP(String publicIP) {
            this.publicIP = publicIP;
            return this;
        }

        public Builder publicIPId(String publicIPId) {
            this.publicIPId = publicIPId;
            return this;
        }

        public Builder publicPort(int publicPort) {
            this.publicPort = publicPort;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder CIDRs(Set<String> CIDRs) {
            this.CIDRs = CIDRs;
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public LoadBalancerRule build() {
            return new LoadBalancerRule(this.id, this.account, this.algorithm, this.description, this.domain, this.domainId, this.name, this.privatePort, this.publicIP, this.publicIPId, this.publicPort, this.state, this.zoneId, this.CIDRs);
        }
    }

    public static enum Algorithm {
        SOURCE,
        ROUNDROBIN,
        LEASTCONN,
        UNRECOGNIZED;


        public String toString() {
            return this.name().toLowerCase();
        }

        public static Algorithm fromValue(String algorithm) {
            try {
                return Algorithm.valueOf(((String)Preconditions.checkNotNull((Object)algorithm, (Object)"algorithm")).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum State {
        ADD,
        ACTIVE,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)state, (Object)"state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

