/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.gson.annotations.SerializedName;
import java.util.Map;
import java.util.SortedSet;

public class NetworkService
implements Comparable<NetworkService> {
    private String name;
    @SerializedName(value="capability")
    private SortedSet<? extends Capability> capabilities = ImmutableSortedSet.of();

    NetworkService() {
    }

    public NetworkService(String name) {
        this(name, (Map<String, String>)ImmutableMap.of());
    }

    public NetworkService(String name, Map<String, String> capabilities) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        ImmutableSortedSet.Builder internal = ImmutableSortedSet.naturalOrder();
        for (Map.Entry capabililty : ((Map)Preconditions.checkNotNull(capabilities, (Object)"capabilities")).entrySet()) {
            internal.add((Object)new Capability((String)capabililty.getKey(), (String)capabililty.getValue()));
        }
        this.capabilities = internal.build();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getCapabilities() {
        ImmutableSortedMap.Builder returnVal = ImmutableSortedMap.naturalOrder();
        for (Capability capability : this.capabilities) {
            returnVal.put((Object)capability.name, (Object)capability.value);
        }
        return returnVal.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkService that = (NetworkService)o;
        if (!Objects.equal(this.capabilities, that.capabilities)) {
            return false;
        }
        return Objects.equal((Object)this.name, (Object)that.name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.capabilities, this.name});
    }

    public String toString() {
        return "NetworkService{name='" + this.name + '\'' + ", capabilities=" + this.capabilities + '}';
    }

    @Override
    public int compareTo(NetworkService o) {
        return this.name.compareTo(o.getName());
    }

    private static class Capability
    implements Comparable<Capability> {
        private String name;
        private String value;

        private Capability() {
        }

        private Capability(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Capability that = (Capability)o;
            if (!Objects.equal((Object)this.name, (Object)that.name)) {
                return false;
            }
            return Objects.equal((Object)this.value, (Object)that.value);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.value});
        }

        public String toString() {
            return "[name=" + this.name + ", value=" + this.value + "]";
        }

        @Override
        public int compareTo(Capability o) {
            return this.name.compareTo(o.name);
        }
    }
}

