/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.jclouds.cloudstack.domain.StorageType;

public class ServiceOffering
implements Comparable<ServiceOffering> {
    private String id;
    private String name;
    @SerializedName(value="displaytext")
    private String displayText;
    private Date created;
    private String domain;
    @SerializedName(value="domainid")
    private String domainId;
    @SerializedName(value="cpunumber")
    private int cpuNumber;
    @SerializedName(value="cpuspeed")
    private int cpuSpeed;
    private int memory;
    @SerializedName(value="offerha")
    private boolean haSupport;
    @SerializedName(value="storagetype")
    private StorageType storageType;
    private String tags;
    @SerializedName(value="defaultuse")
    private boolean defaultUse;
    @SerializedName(value="hosttags")
    private String hostTags;
    @SerializedName(value="issystem")
    private boolean systemOffering;
    @SerializedName(value="limitcpuuse")
    private boolean cpuUseLimited;
    @SerializedName(value="networkrate")
    private long networkRate;
    @SerializedName(value="systemvmtype")
    private boolean systemVmType;

    public static Builder builder() {
        return new Builder();
    }

    public ServiceOffering(String id, String name, String displayText, Date created, String domain, String domainId, int cpuNumber, int cpuSpeed, int memory, boolean haSupport, StorageType storageType, Set<String> tags, boolean defaultUse, String hostTags, boolean systemOffering, boolean cpuUseLimited, long networkRate, boolean systemVmType) {
        this.id = id;
        this.name = name;
        this.displayText = displayText;
        this.created = created;
        this.domain = domain;
        this.domainId = domainId;
        this.cpuNumber = cpuNumber;
        this.cpuSpeed = cpuSpeed;
        this.memory = memory;
        this.haSupport = haSupport;
        this.storageType = storageType;
        this.tags = tags.size() == 0 ? null : Joiner.on((char)',').join(tags);
    }

    ServiceOffering() {
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public int getCpuNumber() {
        return this.cpuNumber;
    }

    public int getCpuSpeed() {
        return this.cpuSpeed;
    }

    public int getMemory() {
        return this.memory;
    }

    public boolean supportsHA() {
        return this.haSupport;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public boolean isDefaultUse() {
        return this.defaultUse;
    }

    public String getHostTags() {
        return this.hostTags;
    }

    public boolean isSystemOffering() {
        return this.systemOffering;
    }

    public boolean isCpuUseLimited() {
        return this.cpuUseLimited;
    }

    public long getNetworkRate() {
        return this.networkRate;
    }

    public boolean isSystemVmType() {
        return this.systemVmType;
    }

    public Set<String> getTags() {
        return this.tags != null ? ImmutableSet.copyOf((Iterable)Splitter.on((char)',').split((CharSequence)this.tags)) : ImmutableSet.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceOffering that = (ServiceOffering)o;
        if (!Objects.equal((Object)this.cpuNumber, (Object)that.cpuNumber)) {
            return false;
        }
        if (!Objects.equal((Object)this.cpuSpeed, (Object)that.cpuSpeed)) {
            return false;
        }
        if (!Objects.equal((Object)this.created, (Object)that.created)) {
            return false;
        }
        if (!Objects.equal((Object)this.displayText, (Object)that.displayText)) {
            return false;
        }
        if (!Objects.equal((Object)this.domain, (Object)that.domain)) {
            return false;
        }
        if (!Objects.equal((Object)this.domainId, (Object)that.domainId)) {
            return false;
        }
        if (!Objects.equal((Object)this.haSupport, (Object)that.haSupport)) {
            return false;
        }
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.memory, (Object)that.memory)) {
            return false;
        }
        if (!Objects.equal((Object)this.name, (Object)that.name)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.storageType), (Object)((Object)that.storageType))) {
            return false;
        }
        return Objects.equal((Object)this.tags, (Object)that.tags);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.cpuNumber, this.cpuSpeed, this.created, this.displayText, this.domain, this.domainId, this.haSupport, this.id, this.memory, this.name, this.storageType, this.tags});
    }

    public String toString() {
        return "ServiceOffering{id=" + this.id + ", name='" + this.name + '\'' + ", displayText='" + this.displayText + '\'' + ", created=" + this.created + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", cpuNumber=" + this.cpuNumber + ", cpuSpeed=" + this.cpuSpeed + ", memory=" + this.memory + ", haSupport=" + this.haSupport + ", storageType=" + (Object)((Object)this.storageType) + ", tags='" + this.tags + '\'' + ", defaultUse=" + this.defaultUse + ", hostTags='" + this.hostTags + '\'' + ", systemOffering=" + this.systemOffering + ", cpuUseLimited=" + this.cpuUseLimited + ", networkRate=" + this.networkRate + ", systemVmType=" + this.systemVmType + '}';
    }

    @Override
    public int compareTo(ServiceOffering arg0) {
        return this.id.compareTo(arg0.getId());
    }

    public static class Builder {
        private String id;
        private String name;
        private String displayText;
        private Date created;
        private String domain;
        private String domainId;
        private int cpuNumber;
        private int cpuSpeed;
        private int memory;
        private boolean haSupport;
        private StorageType storageType;
        private boolean defaultUse;
        private String hostTags;
        private boolean systemOffering;
        private boolean cpuUseLimited;
        private long networkRate;
        private boolean systemVmType;
        private Set<String> tags = ImmutableSet.of();

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder displayText(String displayText) {
            this.displayText = displayText;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder cpuNumber(int cpuNumber) {
            this.cpuNumber = cpuNumber;
            return this;
        }

        public Builder cpuSpeed(int cpuSpeed) {
            this.cpuSpeed = cpuSpeed;
            return this;
        }

        public Builder memory(int memory) {
            this.memory = memory;
            return this;
        }

        public Builder haSupport(boolean haSupport) {
            this.haSupport = haSupport;
            return this;
        }

        public Builder storageType(StorageType storageType) {
            this.storageType = storageType;
            return this;
        }

        public Builder tags(Set<String> tags) {
            this.tags = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(tags, (Object)"tags")));
            return this;
        }

        public Builder defaultUse(boolean defaultUse) {
            this.defaultUse = defaultUse;
            return this;
        }

        public Builder hostTags(String hostTags) {
            this.hostTags = hostTags;
            return this;
        }

        public Builder systemOffering(boolean systemOffering) {
            this.systemOffering = systemOffering;
            return this;
        }

        public Builder cpuUseLimited(boolean cpuUseLimited) {
            this.cpuUseLimited = cpuUseLimited;
            return this;
        }

        public Builder networkRate(long networkRate) {
            this.networkRate = networkRate;
            return this;
        }

        public Builder systemVmType(boolean systemVmType) {
            this.systemVmType = systemVmType;
            return this;
        }

        public ServiceOffering build() {
            return new ServiceOffering(this.id, this.name, this.displayText, this.created, this.domain, this.domainId, this.cpuNumber, this.cpuSpeed, this.memory, this.haSupport, this.storageType, this.tags, this.defaultUse, this.hostTags, this.systemOffering, this.cpuUseLimited, this.networkRate, this.systemVmType);
        }
    }
}

